<?php
//
// Nagios Fusion API Documentation
// Copyright (c) 2008-2017 Nagios Enterprises, LLC. All rights reserved.
//

require_once(dirname(__FILE__) . '/../includes/base.inc.php');

// Initialization stuff
init_session();

// Grab GET or POST variables and check pre-reqs
grab_request_vars();
check_authentication(false);

route_request();

function route_request()
{
    $page = grab_request_var("page", "");

    switch ($page) {
        default:
            show_main_api_page();
            break;
    }
}

function show_main_api_page()
{
    //$backend_url = get_product_portal_backend_url();
    // TODO: Recreate the get_apikey function
    $apikey = get_user_attr('api_key');
    $title = _("REST API - Introduction");
    child_page($title);
?>

    <!-- Keep the help section part of the page -->
    <script>
    $(document).ready(function() {
        resize_nav();
        $(window).resize(function() {
            resize_nav();
        });

        // perform some basic highlighting on the code samples
        $('pre.code').html(function(index, html) {
            return html.replace(/\/\/.*/g, '<span style="color: #00b200;">$&</span>');
        });
    });

    function resize_nav() {
        var width = $('.col-md-3').width();
        $('.help-right-nav').css('width', width);
    }
    </script>

    <div class="container-fluid" style="padding: 0 5px;">
        <div class="row">
            <div class="col-sm-8 col-md-9 col-lg-9">

                <h1><?php echo _('REST API - Introduction'); ?></h1>
                <!-- <p><?php echo _('New in Nagios Fusion 4.1 is a REST API that includes far more features and control over the Nagios Fusion system. This documentation explains how to use the new API to read, write, and delete data in the Nagios Fusion system through commands that are authenticated via Nagios Fusion API keys.'); ?></p> -->

                <div class="help-section">
                    <a name="start"></a>
                    <h4><?php echo _('Getting Started'); ?></h4>
                    <p><?php echo _('To gain access to the new REST API use the URL formatted as such'); ?>:</p>
                    <p>
                        <code><?php echo get_base_url(); ?>api/v1/</code> <a href="<?php echo get_base_url(); ?>api/v1/" target="_blank" rel="noreferrer" class="tt-bind" title="<?php echo _('Open URL in browser window'); ?>"><i class="fa fa-share icon-large"></i></a>
                    </p>
                </div>

                <div class="help-section">
                    <a name="auth"></a>
                    <h4><?php echo _('Authentication'); ?></h4>
                    <p><?php echo _('Each user has their own API key to access the API. Normal users are allowed to have read access if the <em>Allow API Access</em> setting is selected in the user management Edit/Create pages. Every admin has full access to the API. Access to the documentation is restricted to users who have API access. Normal Fusion users, which have read only API access, will only be able to see the documentation about the objects section.'); ?></p>
                    <p><?php echo _('Whether you connect via a browser, cURL, or any other way you will need to pass the API key as a <em>GET</em> variable named <code>apikey</code> just like the example in <em>Getting Started</em>.'); ?></p>
                    <p><?php echo _('Your API Key:'); ?> <code><?php echo $apikey; ?></code></p>
                    <p><?php echo _('Access Level:'); ?> <?php if (is_admin()) { echo "Full Access"; } ?></p>
                </div>

                <div class="help-section">
                    <a name="usage"></a>
                    <h4><?php echo _('Basic Usage'); ?></h4>
                    <?php if (is_admin()) { ?>
                    <p><?php echo _('The example below is using the <code>GET system/status</code> command which shows general information about this Nagios Fusion server. Adding <code>pretty=1</code> to the URL will print the JSON in human readable format like the example below and can be used on any API request that returns output.'); ?></p>
					<div>
                        <h6><?php echo _('Example cURL Request'); ?>:</h6>
                        <pre class="curl-request">curl -XGET "<?php echo get_base_url(); ?>api/v1/system/status?apikey=<?php echo $apikey; ?>&amp;pretty=1"</pre> <a href="<?php echo get_base_url(); ?>api/v1/system/status?apikey=<?php echo $apikey; ?>&amp;pretty=1" target="_blank" rel="noreferrer" class="api-popout tt-bind" title="<?php echo _('Open URL in browser window'); ?>"><i class="fa fa-share icon-large"></i></a>
                        <div class="clear"></div>
                    </div>
                    <h6><?php echo _('Response JSON'); ?>:</h6>
                    <pre>
{
    "load": {
        "user": "5.99",
        "nice": "0.00",
        "system": "0.91",
        "iowait": "0.25",
        "steal": "0.00",
        "idle": "92.84"
    },
    "memory": {
        "load1": "0.18",
        "load5": "0.21",
        "load15": "0.21"
    },
    "swap": {
        "total": "3774",
        "used": "1592",
        "free": "278",
        "shared": "182",
        "buffers": "1903",
        "cached": "1646"
    },
    "cpu": {
        "total": "2559",
        "used": "578",
        "free": "1981"
    }
}</pre>
                <?php } else { ?>
                    <p><?php echo _('The example below is using the <code>GET objects/host</code> command which shows hosts that this users can view in the Nagios Fusion server. Adding <code>pretty=1</code> to the URL will print the JSON in human readable format like the example below and can be used on any API request that returns output.'); ?></p>
                    <div>
                        <h6><?php echo _('Example cURL Request'); ?>:</h6>
                        <pre class="curl-request">curl -XGET "<?php echo get_base_url(); ?>api/v1/objects/host?apikey=<?php echo $apikey; ?>&amp;pretty=1"</pre> <a href="<?php echo get_base_url(); ?>api/v1/objects/host?apikey=<?php echo $apikey; ?>&amp;pretty=1" target="_blank" rel="noreferrer" class="api-popout tt-bind" title="<?php echo _('Open URL in browser window'); ?>"><i class="fa fa-share icon-large"></i></a>
                        <div class="clear"></div>
                    </div>
                    <h6><?php echo _('Response JSON'); ?>:</h6>
                    <pre>{
    "hostlist": {
        "recordcount": "12",
        "host": [
            {
                "@attributes": {
                    "id": "202"
                },
                "instance_id": "1",
                "host_name": "tset",
                "is_active": "1",
                "config_type": "1",
                "alias": "tset",
                "display_name": "tset",
                "address": "127.0.53.53",
                "check_interval": "40",
                "retry_interval": "5",
                "max_check_attempts": "4",
                "first_notification_delay": "0",
                "notification_interval": "1",
                "passive_checks_enabled": "1",
                "active_checks_enabled": "1",
                "notifications_enabled": "0",
                "notes": "",
                "notes_url": "",
                "action_url": "",
                "icon_image": "server.png",
                "icon_image_alt": "",
                "statusmap_image": "server.png"
            }
        ]
    }
}</pre>
                <?php } ?>
                </div>

            </div>

            <div class="col-sm-4 col-md-3 col-lg-3">
                <div class="well help-right-nav">
                    <h5><?php echo _('REST API - Introduction'); ?></h5>
                    <ol>
                        <li><a href="#start"><?php echo _('Getting Started'); ?></a></li>
                        <li><a href="#auth"><?php echo _('Authentication'); ?></a></li>
                        <li><a href="#usage"><?php echo _('Basic Usage'); ?></a></li>
                        <!--
                        <li><a href="#config"><?php echo _('Examples'); ?></a></li>
                        <ul>
                            <li><a href="#addhost"><?php echo _('Adding a Host'); ?></a></li>
                            <li><a href="#addservice"><?php echo _('Adding a Service'); ?></a></li>
                            <li><a href="#removeobject"><?php echo _('Remove Host/Service'); ?></a></li>
                            <li><a href="#aplpyconfig"><?php echo _('Apply Configuration'); ?></a></li>
                        </ul>
                        -->
                    </ol>
                    <ul style="padding: 0; margin: 15px 0 0 0; list-style-type: none;">
                        <li><a href="api-system-reference.php"><?php echo _('System Reference'); ?></a> <i class="fa fa-external-link"></i></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

<?php
}