<?php
require_once(dirname(__FILE__) . '/../includes/base.inc.php');


help_main();

function help_main() {

    $title = _('Help for Nagios Fusion');

    child_page($title);
    echo well_top_page_header($title);

    global $dashlets;

    $getting_started = empty($dashlets['getting_started']) ? false : $dashlets['getting_started'];

    echo '<p>' . _('We keep the most up to date information online! Use the links below, or on theside navigation bar to quickly locate the specific documents you require.') . '</p>';

    ?>

    <div style="width: 500px; float: left;">
        <h5 class="ul"><?php echo _('Get Help Online'); ?></h5>
        <p><?php echo _('Get help for Nagios Fusion online.'); ?></p>
        <ul>
            <li><a href="https://support.nagios.com/forum" target="_blank"><strong><?php echo _('Visit the Support Forum'); ?></strong></a></li>
            <li><a href="https://support.nagios.com/kb/category.php?id=5" target="_blank"><strong><?php echo _('Visit the Knowledge Base'); ?></strong></a></li>
            <li><a href="https://exchange.nagios.com/" target="_blank"><strong><?php echo _('Visit the Nagios Exchange'); ?></strong></a></li>
        </ul>
        <h5 class="ul"><?php echo _('More Options'); ?></h5>
        <ul>
            <li>
                <a href="https://www.nagios.com/products/nagios-fusion/" target="_blank"><strong><?php echo _('Learn about Nagios Fusion'); ?></strong></a>
                <br /><?php echo _('Learn more about Nagios Fusion and its capabilities.'); ?></li>
        </ul>
    </div>

    <?php

    if ($getting_started) {
        echo '<div style="margin: 0 40px 20px; float: left;">';
        echo "<h2>{$getting_started[DASHLET_TITLE]}</h2>";
        echo get_inline_dashlet_html($getting_started);
        echo '</div>';
    }
}
