<?php

register_customlogin();
function register_customlogin() {

    $component_args = array(

        COMPONENT_NAME              => 'customlogin',
        COMPONENT_TITLE             => _('Custom Login'),
        COMPONENT_VERSION           => '1.0.0',
        COMPONENT_DATE              => '05/12/2017',
        COMPONENT_AUTHOR            => 'Nagios Enterprises, LLC',
        COMPONENT_DESCRIPTION       => _('Override the Nagios Fusion login splash panel with your own custom information.'),
        COMPONENT_REQUIRES_VERSION  => 3990,
        COMPONENT_CONFIG_FUNCTION   => 'customlogin_config_func',
    );

    register_component($component_args);
}

function customlogin_config_func($mode = null) {

    $output = '';

    switch ($mode) {

        case COMPONENT_CONFIG_MODE_GET:

            $enabled = false;

            $customlogin_include_file = get_option('customlogin_include_file', '');
            if (!empty($customlogin_include_file))
                $enabled = true;

            // check if postback
            if (grab_request_var('customlogin_include_file') !== null)
                $customlogin_include_file = grab_request_var('customlogin_include_file', $customlogin_include_file);

            $output = '
                <script type="text/javascript">
                    $(function() {
                        $("#enabled").click(function() {
                            if ($(this).is(":checked")) {
                                set_dynamic_required($("#customlogin_include_file"));
                            } else {
                                remove_dynamic_required($("#customlogin_include_file"));                            
                            }
                        });
                    });
                </script>
                <h5 class="ul">' . _('Custom Login Settings') . '</h5>

                <table class="table table-condensed table-no-border table-auto-width">
                    <tr>
                        <td></td>
                        <td class="checkbox">
                            <label>
                                <input type="checkbox" class="checkbox" id="enabled" name="enabled" ' . is_checked($enabled, true, true) . '>
                                '._('Enable Custom Login Splash Panel').'
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <td class="vt">
                            <label for="customlogin_include_file">' . _('Include File') . ':</label>
                        </td>
                        <td>
                            <input type="text" size="40" name="customlogin_include_file" id="customlogin_include_file" value="' . encode_html($customlogin_include_file) . '" class="form-control" placeholder="/path/to/custom.login.php"> ' .
                            pop(_('Include File'), _("This is a file located on your Fusion server's filesystem.")) . 
                            '<div class="subtext">' . _('The include file to be used on the login page.') . '<br /><strong>' . _('This is required when enabled.') . '</strong></div>
                        </td>
                    </tr>
                </table>';
            break;

        case COMPONENT_CONFIG_MODE_SET:

            $enabled = grab_request_var('enabled', false);
            $customlogin_include_file = grab_request_var('customlogin_include_file');

            if (!$enabled) {
                delete_option('customlogin_include_file');
            } else {

                // no empty include file
                if (empty($customlogin_include_file)) {
                    flash_message(_('Target URL is not a valid URL.'), 'error');
                    return false;
                }

                // include file must exist!
                if (!@file_exists($customlogin_include_file) || !@is_readable($customlogin_include_file)) {
                    flash_message(_('The include file you specified does not exist or is not readable.'), 'error');
                    return false;                    
                }

                set_option('customlogin_include_file', $customlogin_include_file);
            }
            
            return true;

            break;
    }

    return $output;
}
