<?php

register_customlogo();
function register_customlogo() {

    $component_args = array(

        COMPONENT_NAME              => 'customlogo',
        COMPONENT_TITLE             => _('Custom Logo'),
        COMPONENT_VERSION           => '1.0.1',
        COMPONENT_DATE              => '05/12/2017',
        COMPONENT_AUTHOR            => 'Nagios Enterprises, LLC',
        COMPONENT_DESCRIPTION       => _('Override the Nagios Fusion logo with your own custom logo.'),
        COMPONENT_REQUIRES_VERSION  => 3990,
        COMPONENT_CONFIG_FUNCTION   => 'customlogo_config_func',

        COMPONENT_FUNCTION          => 'customlogo_successful_registration',
    );

    register_component($component_args);
}

function customlogo_successful_registration() {

    $customlogo_data = get_option('customlogo_data');
    if ($customlogo_data !== null) {

        register_callback(CALLBACK_FUSION_LOGO, 'customlogo_override');
    }
}

function customlogo_config_func($mode = null) {

    $output = '';

    switch ($mode) {

        case COMPONENT_CONFIG_MODE_GET:

            $customlogo_data = unpack_array(get_option('customlogo_data', false));

            $default_logo_img = 'nagios_logo_white_transbg.png';

            $enabled                = grab_array_var($customlogo_data, 'enabled', (bool) $customlogo_data);
            $display_fusion_logo    = grab_array_var($customlogo_data, 'display_fusion_logo', false);
            $logo_img               = grab_array_var($customlogo_data, 'logo_img', $default_logo_img);
            $logo_text              = grab_array_var($customlogo_data, 'logo_text', ' ' . _('Fusion'));
            $logo_alt               = grab_array_var($customlogo_data, 'logo_alt', _('Nagios Fusion'));
            $logo_target            = grab_array_var($customlogo_data, 'logo_target', '_blank');
            $logo_url               = grab_array_var($customlogo_data, 'logo_url', get_base_url());

            // is this postback?
            if (grab_request_var('logo_img') !== null) {

                $enabled = grab_request_var('enabled', $enabled);
                $display_fusion_logo = grab_request_var('display_fusion_logo', $display_fusion_logo);
                $logo_img = grab_request_var('logo_img', $logo_img);
                $logo_text = grab_request_var('logo_text', $logo_text);
                $logo_alt = grab_request_var('logo_alt', $logo_alt);
                $logo_target = grab_request_var('logo_target', $logo_target);
                $logo_url = grab_request_var('logo_url', $logo_url);
            }

            $output = '
                <script type="text/javascript">
                    $(function() {
                        $("#enabled").click(function() {
                            if ($(this).is(":checked")) {
                                $("#logo_img").val(' . json_encode($logo_img) . ');
                            } else {
                                $("#logo_img").val(' . json_encode($default_logo_img) . ');
                            }
                        });
                    });
                </script>

                <p>' . _('Use the custom logo component to change the logo in the upper left-hand corner of the web interface.') . '</p>
                            
                <h5 class="ul">' . _('Custom Logo Settings') . '</h5>

                <table class="table table-condensed table-no-border table-auto-width">
                    <tr>
                        <td></td>
                        <td class="checkbox">
                            <label>
                                <input type="checkbox" class="checkbox" id="enabled" name="enabled" ' . is_checked($enabled, true, false) . '>
                                ' . _('Enable Custom Logo') . '
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <td></td>
                        <td class="checkbox">
                            <label>
                                <input type="checkbox" class="checkbox" id="display_fusion_logo" name="display_fusion_logo" ' . is_checked($display_fusion_logo, true, false) . '>
                                ' . _('Display the Nagios Fusion logo next to the header') . '
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <td class="vt">
                            <label for="logo_img">' . _('Logo Image') . ':</label>
                        </td>
                        <td>
                            <input type="text" size="40" name="logo_img" id="logo_img" placeholder="' . $default_logo_img . '" value="' . encode_html($logo_img) . '" class="form-control" required="true">
                            <div class="subtext">' 
                            . _('The filename of the image to use as the logo.') 
                            . '<br />' 
                            . _('The image must be an absolute URL (e.g.: http://path/to/image) or it must already be installed in') 
                            . ' <br /><i>' . get_root_dir() . '/html/static/images/</i> (100 &times; 42 px)
                            </div>
                        </td>
                    </tr>

                    <tr>
                        <td class="vt">
                            <label for="logo_text">' . _('Logo Text') . ':</label>
                        </td>
                        <td>
                            <input type="logo_text" size="40" name="logo_text" id="logo_text" value="' . encode_html($logo_text) . '" class="form-control">
                            <div class="subtext">' . _("The text shown to the right of the custom logo.") . '</div>
                        </td>
                    </tr>

                    <tr>
                        <td class="vt">
                            <label for="logo_alt">' . _('Logo Alternate Text') . ':</label>
                        </td>
                        <td>
                            <input type="logo_alt" size="40" name="logo_alt" id="logo_alt" value="' . encode_html($logo_alt) . '" class="form-control">
                            <div class="subtext">' . _('Optional text to use for the ALT and TITLE attributes of the logo.') . '</div>
                        </td>
                    </tr>
                    <tr>
                        <td class="vt">
                            <label for="logo_target">' . _('Logo Target') . ':</label>
                        </td>
                        <td>
                            <input type="logo_target" size="40" name="logo_target" id="logo_target" value="' . encode_html($logo_target) . '" style="width: 100px;" class="form-control">
                            <div class="subtext">' . _('Optional target when clicking on logo. (e.g.: _blank = new tab, _top = same frame)') . '</div>
                        </td>
                    </tr>
                    <tr>
                        <td class="vt">
                            <label for="logo_url">' . _('Target URL') . ':</label>
                        </td>
                        <td>
                            <input type="logo_url" size="40" name="logo_url" id="logo_url" value="' . encode_html($logo_url) . '" class="form-control">
                            <div class="subtext">' . _('An optional URL that the logo should link to.') . '</div>
                        </td>
                    </tr>
                </table>';
            break;

        case COMPONENT_CONFIG_MODE_SET:
            
            $enabled = grab_request_var('enabled', false);
            $display_fusion_logo = grab_request_var('display_fusion_logo', false);
            $logo_img = grab_request_var('logo_img');
            $logo_text = grab_request_var('logo_text');
            $logo_alt = grab_request_var('logo_alt');
            $logo_target = grab_request_var('logo_target');
            $logo_url = grab_request_var('logo_url');

            if (empty($logo_img)) {
                flash_message(_('Logo Image is a required field.'), 'error');
                return false;
            }

            // check if logo_img is an absolute url (kind of. we don't use filter here because of different languages), or a local filesystem image
            // and if it isn't an absolute url, make sure the file exists
            if (strpos($logo_img, '://') === false) {
                $logo_img = sanitize_filename($logo_img);
                $logo_img_dir = get_root_dir() . '/html/static/images/';
                if (!@file_exists($logo_img_dir . $logo_img)) {
                    flash_message(_('Specified Logo Image is not present in') . " {$logo_img_dir}.", 'error');
                    return false;
                }
            }

            // check if url is valid (kind of. we don't use filter here because of different languages)
            if (!empty($logo_url) && strpos($logo_url, '://') === false) {
                flash_message(_('Target URL is not a valid URL.'), 'error');
                return false;
            }

            if (!$enabled) {
                delete_option('customlogo_data');
            } else {
                $customlogo_data = array(
                    'display_fusion_logo'   => $display_fusion_logo,
                    'logo_img'              => $logo_img,
                    'logo_text'             => $logo_text,
                    'logo_alt'              => $logo_alt,
                    'logo_target'           => $logo_target,
                    'logo_url'              => $logo_url,
                    );

                $customlogo_data = pack_array($customlogo_data);
                set_option('customlogo_data', $customlogo_data);
            }

            return true;

            break;
    }

    return $output;
}

// $cbargs is what we populate to set the img!
function customlogo_override($cb, &$cbargs) {

    $customlogo_data = unpack_array(get_option('customlogo_data'));
    if ($customlogo_data !== null) {

        $display_fusion_logo    = grab_array_var($customlogo_data, 'display_fusion_logo');
        $logo_img               = grab_array_var($customlogo_data, 'logo_img');
        $logo_text              = grab_array_var($customlogo_data, 'logo_text');
        $logo_alt               = grab_array_var($customlogo_data, 'logo_alt');
        $logo_target            = grab_array_var($customlogo_data, 'logo_target');
        $logo_url               = grab_array_var($customlogo_data, 'logo_url');

        $cbargs['display_fusion_logo'] = (bool) $display_fusion_logo;

        if ($logo_img !== null) {
            $cbargs['logo_img'] = get_base_url() . 'static/images/' . $logo_img;
            if (strpos($logo_img, '://'))
                $cbargs['logo_img'] = $logo_img;
        }

        if ($logo_text !== null)
            $cbargs['logo_text'] = $logo_text;

        if ($logo_alt !== null)
            $cbargs['logo_alt'] = $logo_alt;

        if ($logo_target !== null)
            $cbargs['logo_target'] = $logo_target;

        if ($logo_url !== null)
            $cbargs['logo_url'] = $logo_url;
    }
}