<?php
require_once(dirname(__FILE__) . '/../component-helper.inc.php');

route();
function route()
{
    search_home();
}

function search_home() {
    $q = grab_request_var('q', '');
    $t = grab_request_var('t', null);

    $title = _('Find Objects');
    child_page($title);
    echo well_top_page_header($title);
?>

<div class="container-fluid" style="margin: 10px -10px;">
    <div class="row">
        <div class="col-md-12">

            <!-- Add explanatory text at the top of the search -->
            <small class="search-description" style="display: block; margin-bottom: 10px; font-size: 12px;">
                This tool is used to search for hosts/services across all fused XI/Core instances.
            </small>

            <form action="" method="get">
                <select name="t" class="form-control">
                    <option value="host" <?php if ($t == 'host') { echo 'selected'; } ?>><?php echo _('Host'); ?></option>
                    <option value="service"  <?php if ($t == 'service') { echo 'selected'; } ?>><?php echo _('Service'); ?></option>
                </select>
                <input type="text" name="q" class="form-control" value="<?php echo encode_form_val($q); ?>">
                <button type="submit" class="btn btn-sm btn-default" style="vertical-align: top;"><?php echo _('Search'); ?></button>
            </form>

            <?php echo search_results($q, $t); ?>

        </div>
    </div>
</div>

<?php
}

function search_results($q, $t)
{
    if (empty($q) || empty($t)) {
        return;
    }
    if (!in_array($t, array('host', 'service', 'hostgroup', 'servicegroup'))) {
        return;
    }

    // Do actual searching
    $results = array();
    $servers = get_servers();

    foreach ($servers as $server) {
        $url = $server['url'] . 'api/v1/objects/' . $t . '?fusekey=' . urlencode($server['fusekey']);
        if ($t == 'host') {
            $url .= '&host_name=lk:' . urlencode($q);
        } else if ($t == 'service') {
            $url .= '&service_description=lk:' . urlencode($q);
        }
        $x = load_url($url);
        if ($x) {
            $data = json_decode($x, true);
            if ($data['recordcount'] > 0) {
                foreach ($data[$t] as $obj) {
                    $tmp = array(
                        'server' => $server['name'],
                        'link' => $server['url'].'includes/components/xicore/status.php'
                    );
                    if ($obj['host_name']) {
                        $tmp['host'] = $obj['host_name'];
                    }
                    if ($obj['service_description']) {
                        $tmp['service'] = $obj['service_description'];
                    }
                    $results[] = $tmp;
                }
            }
        }
    }

?>

<table class="table table-striped table-auto-width table-bordered">
    <thead>
        <tr>
            <th><?php echo _('Object'); ?></th>
            <th><?php echo _('Server'); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php if (empty($results)) { ?>
        <tr>
            <td colspan="2"><?php echo _('Could not find objects using specified search values.'); ?></td>
        </tr>
        <?php } else {
            // Sort the results before displaying
            foreach ($results as $k => $r) {
                $host[$k] = $r['host'];
            }
            array_multisort($host, SORT_NATURAL);

            foreach ($results as $r) {
                $name = encode_form_val($r['host']);
                if (array_key_exists('service', $r)) {
                    $name .= ' - ' . encode_form_val($r['service']);
                    $link = $r['link'] . '?show=servicedetail&host=' . urlencode($r['host']) . '&service=' . urlencode($r['service']);
                } else {
                    $link = $r['link'] . '?show=hostdetail&host=' . urlencode($r['host']);
                }
        ?>
            <tr>
                <td><a href="<?php echo encode_form_val($link); ?>" target="_blank"><?php echo $name; ?></a></td>
                <td><?php echo encode_form_val($r['server']); ?></td>
            </tr>
        <?php } } ?>
    </tbody>
</table>

<?php  
}
?>
