<?php
require_once(dirname(__FILE__) . '/../../component-helper.inc.php');
dashlets_data_check();

define('DISPLAY_SERVER_TITLES', true);

bpi_dashlet();
function bpi_dashlet() {

    $server = grab_request_var('server');

    $bpi_data = array();

    if ($server !== 'all') {
        $server = intval($server);
        $bpi_data = fusionbpi_get_server_data($server);
    } else {
        $servers = get_servers();
        foreach ($servers as $this_server) {
            $this_data = fusionbpi_get_server_data($this_server);
            if (is_array($this_data))
                $bpi_data = array_merge($bpi_data, $this_data);
        }
    }

    ?>
    <style type="text/css">
        table.table.service_status_summary_dashlet.bpi-table {

        }

        .content-overflow {
            overflow-y: auto !important;
        }
        
    </style>
    <?php

    $display_titles = true;
    if (!defined('DISPLAY_SERVER_TITLES') || (defined('DISPLAY_SERVER_TITLES') && DISPLAY_SERVER_TITLES == false))
        $display_titles = false;

    foreach ($bpi_data as $server_id => $server_bpi_arr) {

        // yeah this is dumb - but it's to keep the array merge simple
        // if the keys are numerical, array_merge re-orders them
        // so server_id 5 could become server_id 0 and so forth
        $server_id = substr($server_id, 7);

        echo '<table class="table table-condensed table-bordered service_status_summary_dashlet bpi-table">';

        // get the bpi url
        // we display it in the title if the title is shown
        // otherwise we build it for the individual links in the table
        // that aren't otherwise shown
        $url = get_server_base_url($server_id);
        $url = get_appended_server_url($url, SERVER_TYPE_XI, AUTH_TYPE_SESSION, '', '?xiwindow=includes/components/nagiosbpi/index.php');
        $href = '';
        $href_end = '';

        if ($display_titles) {
            $name = get_server_attr('name', $server_id);
            echo '<thead>';
            echo '<tr>';
            echo '<th colspan="3">';
            echo '<a href="' . $url . '" target="_blank">';
            echo  $name . ' ' . _('BPI Status');
            echo '</a>';
            echo '</th>';
            echo '</tr>';
            echo '</thead>';
        } else {

            $href = '<a href="' . $url . '" target="_blank">';
            $href_end = '</a>';
        }

        echo '<tbody>';

        foreach ($server_bpi_arr as $bpi_title => $bpi) {

            $bpi_state = $bpi['state'];
            $bpi_text = $bpi['text'];
            $class = $bpi['class'];

            echo '<tr>';

            echo '<td class="haveservice' . $class . '">';
            echo $bpi_state;
            echo '</td>';

            echo '<td class="title">';
            echo $href;
            echo $bpi_title;
            echo $href_end;
            echo '</td>';

            echo '<td class="text">';
            echo $bpi_text;
            echo '</td>';

            echo '</tr>';
        }

        echo '</tbody>';
        echo '</table>';
    }
}

function fusionbpi_get_server_data($server) {

    $server = get_server($server);
    if ($server === false)
        return false;

    $bpi_data = get_server_polled_key($server, 'bpi', $key_limit = 1);

    if (!isset($bpi_data[0]['bpi']))
        return false;

    $bpi_arr = unpack_array($bpi_data[0]['bpi']);

    $data = array();

    foreach ($bpi_arr as $i => $bpi) {

        if (!isset($bpi['title']) || !isset($bpi['state']) || !isset($bpi['text']))
            continue;

        switch(intval($bpi['state'])) {

        case STATE_OK:
            $state = _('OK');
            $class = 'ok';
            break;

        case STATE_WARNING:
            $state = _('WARNING');
            $class = 'warning';
            break;

        case STATE_CRITICAL:
            $state = _('CRITICAL');
            $class = 'critical';
            break;

        default:
            break;
        }

        $data["server_{$server['server_id']}"][$bpi['title']] = array('state' => $state, 'text' => $bpi['text'], 'class' => $class);
    }

    return $data;
}