<?php

register_fusionbpi();
function register_fusionbpi() {

    $component_args = array(

        COMPONENT_NAME              => 'fusionbpi',
        COMPONENT_TITLE             => _('Nagios XI BPI Status'),
        COMPONENT_VERSION           => '4.0.2',
        COMPONENT_AUTHOR            => 'Nagios Enterprises, LLC',
        COMPONENT_DESCRIPTION       => _('This component grabs your specified Nagios XI BPI data and installs a dashlet to display that information.'),
        COMPONENT_REQUIRES_VERSION  => 4002,

        COMPONENT_FUNCTION          => 'fusionbpi_successful_registration',
    );

    register_component($component_args);
}


function fusionbpi_successful_registration() {

    define('POLL_TYPE_NAGIOSXI_BPI', 'nagiosxi_bpi');

    register_poll_type(
        POLL_TYPE_NAGIOSXI_BPI, 
        "api/v1/objects/bpi",
        "includes/components/nagiosbpi/bpi_display.php?cmd=getbpixml",
        null,
        /* $records = */ false,
        /* $brevity = */ false,
        /* $time_limits = */ false,
        /* $fusekey_specify_user = */ false
    );

    register_poll_callback(SERVER_TYPE_XI, POLL_TYPE_NAGIOSXI_BPI, 'fusionbpi_callback');

    register_fusionbpi_dashlet();
}

function fusionbpi_callback(&$raw_data)
{
    $bpi = $raw_data['bpigroups']['group'];
    $data = array();

    // Fix issue where only a single BPI group causes foreach to loop
    // over the values in the group not the groups themselves
    if (isset($bpi['name'])) {
        $bpi = array($bpi);
    }

    foreach ($bpi as $group) {

        $id = null;
        if (isset($group['@attributes']['id']))
            $id = $group['@attributes']['id'];
        else if (isset($group['name']))
            $id = $group['name'];

        if ($id === null)
            continue;

        if (!isset($group['title']) || !isset($group['current_state']) || !isset($group['status_text']))
            continue;

        $data[$id] = array(
            'title' => $group['title'],
            'state' => intval($group['current_state']),
            'text'  => $group['status_text'],
            );
    }

    return array('bpi' => $data);
}

function register_fusionbpi_dashlet() {

    $dashlet_opts = array(
        DASHLET_NAME        => 'fusionbpi',
        DASHLET_TYPE        => DASHLET_TYPE_COMPONENT,
        DASHLET_SERVER_TYPE => SERVER_TYPE_XI,
        DASHLET_VERSION     => '4.0.2',
        DASHLET_DATE        => '07/31/2018',
        DASHLET_AUTHOR      => 'Nagios Enterprises',
        DASHLET_DESCRIPTION => _('This dashlet displays service status information for Nagios BPI Groups.'),
        DASHLET_COPYRIGHT   => '&copy; 2017-2018 Nagios Enterprises, LLC',
        DASHLET_HOMEPAGE    => 'www.nagios.com',
        DASHLET_LICENSE     => _('Nagios Software License'),
        DASHLET_PREVIEW     => get_components_base_url() . 'fusionbpi/dashlet/bpi_preview.png',
        DASHLET_LOAD_URL    => get_components_base_url() . 'fusionbpi/dashlet/bpi_dashlet.php',
        DASHLET_TITLE       => _('Nagios XI BPI Status'),
        DASHLET_PARAMS      => 'fusionbpi_dashlet_params',
        );

    register_dashlet($dashlet_opts);
}



function fusionbpi_dashlet_params() {

    $servers = array('all' => _('All Servers'));
    foreach (get_servers() as $server) {

        if ($server['server_type'] != SERVER_TYPE_XI)
            continue;

        $servers[$server['server_id']] = $server['name'];
    }

    return array(

        'server' => array(
            'name'      => _('Server'),
            'options'   => $servers, // in the format of array(val => humanreadable)
            ), 
        );

}