<?php

function fusioncore_poll_hoststatus(&$raw_data) {

    $data = array(
        'hosts_pending'         => 0,
        'hosts_up'              => 0,
        'hosts_down'            => 0,
        'hosts_unreachable'     => 0,
        );

    $meta = array(

        'hosts_problems'                    => 0,
        'hosts_problems_unhandled'          => 0,

        'hosts_disabled'                    => 0,
        'hosts_acknowledged'                => 0,
        'hosts_flapping'                    => 0,
        'hosts_downtime'                    => 0,

        'hosts_pending_disabled'            => 0,

        'hosts_up_disabled'                 => 0,
        'hosts_up_downtime'                 => 0,

        'hosts_down_disabled'               => 0,
        'hosts_down_acknowledged'           => 0,
        'hosts_down_downtime'               => 0,

        'hosts_unreachable_disabled'        => 0,
        'hosts_unreachable_acknowledged'    => 0,
        'hosts_unreachable_downtime'        => 0,

        );

    $hoststatuslist = array();

    $xi = false;
    $core = false;

    // xi
    if (!empty($raw_data['hoststatuslist']['hoststatus'])) {

        $xi = true;
        $hoststatuslist = $raw_data['hoststatuslist']['hoststatus'];

        if ($raw_data['hoststatuslist']['recordcount'] == 1)
            $hoststatuslist = array($hoststatuslist);
    }

    // core
    if (!empty($raw_data['data']['hostlist'])) {

        $core = true;
        $hoststatuslist = $raw_data['data']['hostlist'];
    }

    // have to let the poller know we're not the one..
    if (!$xi && !$core)
        return null;

    // host status array
    $host_status = array();

    foreach ($hoststatuslist as $index => $host) {

        $host_name = '';
        $host_alias = '';
        $current_state = '';
        $output = '';

        // grab the meta data
        $disabled = false;
        $downtime = false;
        $acknowledged = false;

        // checks disabled? (xi)
        if (   (isset($host['active_checks_enabled']) && $host['active_checks_enabled'] == 0)
                && (isset($host['passive_checks_enabled']) && $host['passive_checks_enabled'] == 0)) {

            $disabled = true;
            $meta['hosts_disabled']++;
        }

        // checks disabled? (core)
        if (    (isset($host['accept_passive_checks']) && empty($host['accept_passive_checks']))
             && (isset($host['checks_enabled']) && empty($host['checks_enabled']))) {

            $disabled = true;
            $meta['hosts_disabled']++;
         }

        // acknowledged?
        if (!empty($host['problem_acknowledged']) || !empty($host['problem_has_been_acknowledged'])) {

            $acknowledged = true;
            $meta['hosts_acknowledged']++;
        }

        // downtime?
        if (!empty($host['scheduled_downtime_depth'])) {

            $downtime = true;
            $meta['hosts_downtime']++;
        }

        // flapping?
        if (!empty($host['is_flapping']))
            $meta['hosts_flapping']++;

        // xi
        if (isset($host['current_state'])) {

            $current_state = $host['current_state'];

            if (isset($host['name']))
                $host_name = $host['name'];
            if (isset($host['alias']))
                $host_alias = $host['alias'];
            if (isset($host['status_text']))
                $output = $host['status_text'];

            switch ($current_state) {

                case STATE_UP:

                    if (isset($host['has_been_checked']) && $host['has_been_checked'] == 0) {

                        $data['hosts_pending']++;

                        if ($disabled)
                            $meta['hosts_pending_disabled']++;

                    } else {

                        $data['hosts_up']++;

                        if ($disabled)
                            $meta['hosts_up_disabled']++;

                        if ($downtime)
                            $meta['hosts_up_downtime']++;
                    }
                    break;

                case STATE_DOWN:

                    $data['hosts_down']++;

                    $meta['hosts_problems']++;
                    $meta['hosts_problems_unhandled']++;

                    if ($disabled)
                        $meta['hosts_down_disabled']++;

                    if ($acknowledged)
                        $meta['hosts_down_acknowledged']++;

                    if ($downtime)
                        $meta['hosts_down_downtime']++;

                    if ($downtime || $acknowledged)
                        $meta['hosts_problems_unhandled']--;
                    
                    break;

                case STATE_UNREACHABLE:

                    $data['hosts_unreachable']++;

                    $meta['hosts_problems']++;
                    $meta['hosts_problems_unhandled']++;

                    if ($disabled)
                        $meta['hosts_unreachable_disabled']++;

                    if ($acknowledged)
                        $meta['hosts_unreachable_acknowledged']++;

                    if ($downtime)
                        $meta['hosts_unreachable_downtime']++;

                    if ($downtime || $acknowledged)
                        $meta['hosts_problems_unhandled']--;
                    
                    break;
            }
        }

        // core
        if (isset($host['status'])) {

            $status = $host['status'];

            $host_name = $index;
            $host_alias = $host_name;
            if (isset($host['plugin_output']))
                $output = $host['plugin_output'];

            $current_state = STATE_UP;
            switch ($status) {
                case CORE_HOST_DOWN:        $current_state = STATE_DOWN; break;
                case CORE_HOST_UNREACHABLE: $current_state = STATE_UNREACHABLE; break;
            }

            switch($status) {

                case CORE_HOST_PENDING:

                    $data['hosts_pending']++;

                    if ($disabled)
                        $meta['hosts_pending_disabled']++;

                    break;

                case CORE_HOST_UP:

                    $data['hosts_up']++;

                    if ($disabled)
                        $meta['hosts_up_disabled']++;

                    if ($downtime)
                        $meta['hosts_up_downtime']++;

                    break;

                case CORE_HOST_DOWN:

                    $data['hosts_down']++;

                    $meta['hosts_problems']++;
                    $meta['hosts_problems_unhandled']++;

                    if ($disabled)
                        $meta['hosts_down_disabled']++;

                    if ($acknowledged)
                        $meta['hosts_down_acknowledged']++;

                    if ($downtime)
                        $meta['hosts_down_downtime']++;

                    if ($downtime || $acknowledged)
                        $meta['hosts_problems_unhandled']--;

                    break;

                case CORE_HOST_UNREACHABLE:

                    $data['hosts_unreachable']++;

                    $meta['hosts_problems']++;
                    $meta['hosts_problems_unhandled']++;

                    if ($disabled)
                        $meta['hosts_unreachable_disabled']++;

                    if ($acknowledged)
                        $meta['hosts_unreachable_acknowledged']++;

                    if ($downtime)
                        $meta['hosts_unreachable_downtime']++;

                    if ($downtime || $acknowledged)
                        $meta['hosts_problems_unhandled']--;

                    break;
            }
        }


        // build host status array
        $host_status[$host_name] = array(
            'alias'             => $host_alias,
            'current_state'     => $current_state,
            'output'            => $output,
            'disabled'          => intval($disabled),
            'downtime'          => intval($downtime),
            'acknowledged'      => intval($acknowledged),
            );
    }

    $data['hosts_count'] = array_sum($data);
    $data['host_status'] = $host_status;

    return array_merge($data, $meta);
}
