<?php

// Get the current version number from the XI server being polled
// This is primarily going to be used for determining which
// authentication method should be used
function xi_info(&$raw_data, $server = '') {

	global $db;
	$server = get_server($server);
	$server_id = $server['server_id'];
	$data = $raw_data;

	if (array_key_exists('backendinfo', $data)) {
		$version = $data['backendinfo']['productinfo']['productversion'];
	} else if (array_key_exists('version', $data)) {
		$version = $data['version'];
	}

	if (!empty($version)) {
		$db->query('UPDATE servers 
			SET 
			version = :version 
			WHERE server_id = :server_id LIMIT 1');
		$db->bind(':version', $version);
		$db->bind(':server_id', $server_id);
		$db->exec();
	}

	return array('info' => $data);
}
