<?php

function fusioncore_poll_notifications(&$raw_data, $server = '') {

    $server = get_server($server);
    if ($server === false)
        return array();

    $notification_data = array();

    $xi = false;
    $core = false;

    // xi
    if (!empty($raw_data['logentries']['logentry'])) {

        $xi = true;
        $notifications = $raw_data['logentries']['logentry'];

        if ($raw_data['logentries']['recordcount'] == 1)
            $notifications = array($notifications);
    }

    // core
    if (!empty($raw_data['data']['notificationlist'])) {

        $core = true;
        $notifications = $raw_data['data']['notificationlist'];
    }
    
    // have to let the poller know we're not the one..
    if (!$xi && !$core)
        return null;

    foreach ($notifications as $notification) {

        $time = null;
        $contact = null;
        $type = null;
        $host = null;
        $service = null;
        $state = null;
        $method = null;
        $message = null;

        // xi comes back from mysql datetime in the server's timezone
        // core is already epoch
        if (isset($notification['entry_time']))
            $time = convert_server_timestring_to_local_timestring($server, $notification['entry_time']);
        if (isset($notification['timestamp']))
            $time = date('Y-m-d H:i:s', substr($notification['timestamp'], 0, -3)); // core is in microseconds

        if (isset($notification['logentry_type']))
            $type = $notification['logentry_type'];

        // xi looks like: "SERVICE NOTIFICATION: nagiosadmin;192.168.5.43;gigabitethernet20 Status;CRITICAL;xi_service_notification_handler;CRITICAL: Interface gigabitethernet20 (index 68) is down."
        // so we break on the first :, and then explode on ; to get the parts of data we need
        if (isset($notification['logentry_data'])) {

            if (($colon_pos = strpos($notification['logentry_data'], ':')) !== false) {

                $logentry = substr($notification['logentry_data'], $colon_pos + 1);
                $logentry = explode(';', $logentry);

                $element = 0;

                if (!empty($logentry[$element]))
                    $contact = trim($logentry[$element++]);

                if (!empty($logentry[$element]))
                    $host = trim($logentry[$element++]);

                // if this is a service?
                if (count($logentry) == 6 && !empty($logentry[$element]))
                    $service = trim($logentry[$element++]);

                if (!empty($logentry[$element]))
                    $state = trim($logentry[$element++]);

                if (!empty($logentry[$element]))
                    $method = trim($logentry[$element++]);

                if (!empty($logentry[$element]))
                    $message = trim($logentry[$element]);
            }
        }

        if (isset($notification['contact']))
            $contact = $notification['contact'];

        if (isset($notification['host_name']))
            $host = $notification['host_name'];
        if (isset($notification['name']))
            $host = $notification['name'];

        if (isset($notification['description']))
            $service = $notification['description'];

        if (isset($notification['notification_type']))
            $type = $notification['notification_type'];

        if (isset($notification['method']))
            $method = $notification['method'];

        if (isset($notification['message']))
            $message = $notification['message'];

        // we need a type to store from core data
        if ($core) {

            switch($type) {

                case AU_NOTIFICATION_HOST_DOWN:
                    $state = 'DOWN';
                    $type = NSLOG_HOST_NOTIFICATION;
                    break;

                case AU_NOTIFICATION_HOST_UNREACHABLE:
                    $state = 'UNREACHABLE';
                    $type = NSLOG_HOST_NOTIFICATION;
                    break;

                case AU_NOTIFICATION_HOST_RECOVERY:
                    $state = 'UP';
                    $type = NSLOG_HOST_NOTIFICATION;
                    break;
                
                case AU_NOTIFICATION_HOST_CUSTOM:
                    $state = 'CUSTOM';
                    $type = NSLOG_HOST_NOTIFICATION;
                    break;
                
                case AU_NOTIFICATION_HOST_ACK:
                    $state = 'ACK';
                    $type = NSLOG_HOST_NOTIFICATION;
                    break;
                
                case AU_NOTIFICATION_HOST_FLAPPING_START:
                    $state = 'FLAPPINGSTART';
                    $type = NSLOG_HOST_NOTIFICATION;
                    break;
                
                case AU_NOTIFICATION_HOST_FLAPPING_STOP:
                    $state = 'FLAPPINGSTOP';
                    $type = NSLOG_HOST_NOTIFICATION;
                    break;
                
                case AU_NOTIFICATION_SERVICE_CRITICAL:
                    $state = 'CRITICAL';
                    $type = NSLOG_SERVICE_NOTIFICATION;
                    break;
                
                case AU_NOTIFICATION_SERVICE_WARNING:
                    $state = 'WARNING';
                    $type = NSLOG_SERVICE_NOTIFICATION;
                    break;
                
                case AU_NOTIFICATION_SERVICE_RECOVERY:
                    $state = 'UP';
                    $type = NSLOG_SERVICE_NOTIFICATION;
                    break;
                
                case AU_NOTIFICATION_SERVICE_CUSTOM:
                    $state = 'CUSTOM';
                    $type = NSLOG_SERVICE_NOTIFICATION;
                    break;
                
                case AU_NOTIFICATION_SERVICE_ACK:
                    $state = 'ACK';
                    $type = NSLOG_SERVICE_NOTIFICATION;
                    break;
                
                case AU_NOTIFICATION_SERVICE_FLAPPING_START:
                    $state = 'FLAPPINGSTART';
                    $type = NSLOG_SERVICE_NOTIFICATION;
                    break;
                
                case AU_NOTIFICATION_SERVICE_FLAPPING_STOP:
                    $state = 'FLAPPINGSTOP';
                    $type = NSLOG_SERVICE_NOTIFICATION;
                    break;
                
                case AU_NOTIFICATION_SERVICE_UNKNOWN:
                    $state = 'UNKNOWN';
                    $type = NSLOG_SERVICE_NOTIFICATION;
                    break;
            }
        }

        if (!empty($host) && !empty($time))
            $notification_data[] = array(
                'time' => $time,
                'contact' => $contact,
                'type' => $type,
                'host' => $host,
                'service' => $service,
                'state' => $state,
                'method' => $method,
                'message' => $message,
                );
    }

    return array('notification_list' => $notification_data);
}
