<?php

function fusioncore_poll_servicegroupmembers(&$raw_data) {

    $servicegroup_members = array();
    $servicegrouplist = array();

    $xi = false;
    $core = false;

    // xi
    if (!empty($raw_data['servicegrouplist']['servicegroup'])) {
        $xi = true;
        $servicegrouplist = $raw_data['servicegrouplist']['servicegroup'];

        // we have to determine if there is only one a little different here
        // since recordcount all of a sudden means how many services it found instead
        // of how many servicegroups there are!
        if (isset($raw_data['servicegrouplist']['servicegroup']['servicegroup_name']))
            $servicegrouplist = array($servicegrouplist);
    }

    // core
    if (!empty($raw_data['data']['servicegrouplist'])) {
        $core = true;
        $servicegrouplist = $raw_data['data']['servicegrouplist'];
    }

    // have to let the poller know we're not the one..
    if (!$xi && !$core)
        return null;

    foreach($servicegrouplist as $servicegroup) {

        $servicegroup_name = '';
        $servicegroup_alias = '';
        $members = array();

        if ($xi) {

            if (!empty($servicegroup['servicegroup_name']))
                $servicegroup_name = $servicegroup['servicegroup_name'];

            if (isset($servicegroup['members']['service'])) {

                // xi is a bit weird. if theres only one service, then there is no array..
                if (!empty($servicegroup['members']['service']['host_name']) && !empty($servicegroup['members']['service']['service_description'])) {

                    $members[] = array(
                        'host_name' => $servicegroup['members']['service']['host_name'],
                        'service_description' => $servicegroup['members']['service']['service_description'],
                        );

                } else {

                    if (isset($servicegroup['members']['service'])) {
                        foreach ($servicegroup['members']['service'] as $service) {

                            if (!empty($service['host_name'])) {

                                $members[] = array(
                                    'host_name' => $service['host_name'],
                                    'service_description' => $service['service_description'],
                                    );
                            }
                        }
                    }
                }
            }
        }

        if ($core) {

            if (!empty($servicegroup['group_name']))
                $servicegroup_name = $servicegroup['group_name'];

            if (!empty($servicegroup['alias']))
                $servicegroup_alias = $servicegroup['alias'];

            if (isset($servicegroup['members']) && is_array($servicegroup['members'])) {
                foreach ($servicegroup['members'] as $index => $service) {

                    if (!empty($service['host_name']) && !empty($service['service_description'])) {
                        $members[] = array(
                            'host_name' => $service['host_name'],
                            'service_description' => $service['service_description'],
                            );
                    }
                }
            }
        }

        if (empty($servicegroup_alias))
            $servicegroup_alias = $servicegroup_name;

        $servicegroup_members[$servicegroup_name] = array(
            'alias' => $servicegroup_alias,
            'members' => $members,
            );
    }

    return array('servicegroup_members' => $servicegroup_members);
}
