<?php

function nls_cluster_health(&$raw_data) {

	$data = array();

	$data[] = array(
		'cluster_name' => $raw_data['cluster_name'],
		'cluster_status' => $raw_data['status'],
		'timed_out' => $raw_data['timed_out'],
		'number_of_nodes' => $raw_data['number_of_nodes'],
		'number_of_data_nodes' => $raw_data['number_of_data_nodes'],
		'active_primary_shards' => $raw_data['active_primary_shards'],
		'relocating_shards' => $raw_data['relocating_shards'],
		'initializing_shards' => $raw_data['initializing_shards'],
		'unassigned_shards' => $raw_data['unassigned_shards'],
		'delayed_unassigned_shards' => $raw_data['delayed_unassigned_shards'],
		'number_of_pending_tasks' => $raw_data['number_of_pending_tasks'],
		'number_of_in_flight_fetch' => $raw_data['number_of_in_flight_fetch']

	);

	return array('cluster_health' => $data);

}

function nls_cluster_stats(&$raw_data) {

	$data = array();

	$data[] = array(

		'cluster_name' => $raw_data['cluster_name'],
		'status' => $raw_data['status'],
		'indices' => $raw_data['indices']['count'],
		'document_count' => $raw_data['indices']['docs']['count'],
		'store_size' => $raw_data['indices']['store']['size_in_bytes'],
		'total_node_count' => $raw_data['nodes']['count']['total'],
		'client_node_count' => $raw_data['nodes']['count']['client'],
		'master_node_count' => $raw_data['nodes']['count']['master_only'],
		'data_node_count' => $raw_data['nodes']['count']['data_only'],
		'master_data_node_count' => $raw_data['nodes']['count']['master_data'],
		'number_of_available_processors' => $raw_data['nodes']['os']['available_processors'],
		'total_memory' => $raw_data['nodes']['os']['mem']['total_in_bytes'],
		'process_cpu' => $raw_data['nodes']['process']['cpu']['percent'],
		'mem_total_storage_in_bytes' => $raw_data['nodes']['fs']['total_in_bytes'],
		'mem_free_storage_in_bytes' => $raw_data['nodes']['fs']['free_in_bytes'],
		'mem_available_in_bytes' => $raw_data['nodes']['fs']['available_in_bytes'],
		'disk_iops' => $raw_data['nodes']['fs']['disk_io_op'],
		'data_read' => $raw_data['nodes']['fs']['disk_read_size_in_bytes'],
		'data_written' => $raw_data['nodes']['fs']['disk_write_size_in_bytes'],
		'io_size' => $raw_data['nodes']['fs']['disk_io_size_in_bytes'],
		'jvm_heap_used_in_bytes' => $raw_data['nodes']['jvm']['mem']['heap_used_in_bytes'],
		'jvm_heap_max_in_bytes' => $raw_data['nodes']['jvm']['mem']['heap_max_in_bytes']

	);

	return array('cluster_stats' => $data);

}

function nls_index_stats(&$raw_data) {
	
	$data = array();

	foreach ($raw_data as $key => $value) {

		if (!isset($raw_data['indices']))
			continue;

		$indices = $raw_data['indices'];

		foreach ($indices as $index => $stats) {

			// Skip anything that isn't a logstash index
			if ($index == "nagioslogserver" ||
                $index == "nagioslogserver_history" ||
                $index == "kibana-int" ||
                $index == "nagioslogserver_log"
            )
            continue;

			$data[$index] = array(
				'document_count' => $stats['primaries']['docs']['count'],
                'primary_size' => $stats['primaries']['store']['size_in_bytes']
			);
		}

        return array('indices' => $data);
    }

}

function nls_snmp_receivers(&$raw_data) {
    $snmp_receivers = array();

    foreach ($raw_data as $index => $value) {
        $snmp_receivers[$value['_id']] = array(
            //'id' => $value['_id'],
            'index' => $value['_index'],
            'name' => $value['_source']['name'],
            'address' => $value['_source']['address'],
            'port' => $value['_source']['port'],
        );

        switch($value['_source']['version']) {
            case '2':
                $snmp_receivers[$value['_id']]['version'] = 'v2c';
                break;
            case '3':
                $snmp_receivers[$value['_id']]['version'] = 'v3';
                break;
            default:
                break;
        }
    }

    return array('nls_snmp_receivers' => $snmp_receivers);    
}

function nls_nrdp_servers(&$raw_data) {
    $nrdp_servers = array();

    foreach ($raw_data as $index => $value) {
        $nrdp_servers[$value['_id']] = array(
            'index' => $value['_index'],
            'name' => $value['_source']['name'],
            'address' => $value['_source']['address'],
            'token' => $value['_source']['token']
        );
    }

    return array('nls_nrdp_servers' => $nrdp_servers);

}

function nna_cpu_stats(&$raw_data) {

	$data = array();

	$data[] = array(
		'cpu_usage' => $raw_data['cpu_usage']
	);

	return array('nna_cpu' => $data);

}

function nna_memory_stats(&$raw_data) {

	$data = array();

	$data[] = array(
		'used_percent' => $raw_data['used_percent'],
		'swap_percent' => $raw_data['swap_percent']
	);

	return array('nna_memory' => $data);

}

function nna_root_drive_stats(&$raw_data) {

	$data = array();

	$data[] = array(
		'filesystem' => $raw_data['filesystem'],
		'size'       => $raw_data['size'],
		'used'       => $raw_data['used'],
		'available'  => $raw_data['available'],
		'percent'    => $raw_data['percent']
	);

	return array('nna_root_drive' => $data);

}

?>