<?php

function fusioncore_poll_status(&$raw_data) {

    $data = array(
        'monitoring_engine' => 0,
        'notifications' => 0,
        'active_checks' => 0,
        'passive_checks' => 0,
        'event_handlers' => 0,
        );

    // get xi fusekey data
    $status = array();

    // xi
    if (!empty($raw_data))
        $status = $raw_data;

    // core
    if (!empty($raw_data['data']['programstatus']))
        $status = $raw_data['data']['programstatus'];

    if (!empty($status['is_currently_running']) || isset($status['daemon_mode']))
        $data['monitoring_engine'] = 1;

    if (!empty($status['notifications_enabled']) || !empty($status['enable_notifications']))
        $data['notifications'] = 1;

    if (!empty($status['active_host_checks_enabled']) || !empty($status['execute_host_checks']))
        $data['active_checks'] = 1;

    if (!empty($status['active_service_checks_enabled']) || !empty($status['execute_service_checks']))
        $data['active_checks'] = 1;

    if (!empty($status['accept_passive_host_checks']) || !empty($status['passive_host_checks_enabled']))
        $data['passive_checks'] = 1;

    if (!empty($status['accept_passive_service_checks']) || !empty($status['passive_service_checks_enabled']))
        $data['passive_checks'] = 1;

    if (!empty($status['event_handlers_enabled']) || !empty($status['enable_event_handlers']))
        $data['event_handlers'] = 1;

    return $data;
}
