<?php
require_once(dirname(__FILE__) . '/../component-helper.inc.php');


tactical_overview();
function tactical_overview() {

	$sort = grab_request_var('sort');
	$order = grab_request_var('order');
	child_page(_('Tactical Overview'), 'home');
	?>

	<div class="well top">
		<h1 class="fl"><?php echo _('Tactical Overview'); ?></h1>
		<div class="fl" style="line-height: 24px; margin-left: 24px;">
			<a href="?sort=alpha<?php if ($sort == 'alpha' && $order != 'd') echo '&order=d'; ?>">
				<?php echo _('Sort by Server Name'); 
					if ($sort =='alpha' && $order != 'd')
						echo ' (' . _('Desc') . ')';
				?>
			</a> &middot
			<a href="?sort=hostsup<?php if ($sort == 'hostsup' && $order != 'd') echo '&order=d'; ?>">
				<?php echo _('Sort by Up Hosts'); 
					if ($sort =='hostsup' && $order != 'd')
						echo ' (' . _('Desc') . ')';
				?>
			</a> &middot
			<a href="?sort=servicesok<?php if ($sort == 'servicesok' && $order != 'd') echo '&order=d'; ?>">
				<?php echo _('Sort by Ok Services'); 
					if ($sort =='servicesok' && $order != 'd')
						echo ' (' . _('Desc') . ')';
				?>
			</a> &middot
			<a href="?sort=hostsall<?php if ($sort == 'hostsall' && $order != 'd') echo '&order=d'; ?>">
				<?php echo _('Sort by All Hosts'); 
					if ($sort =='hostsall' && $order != 'd')
						echo ' (' . _('Desc') . ')';
				?>
			</a> &middot
			<a href="?sort=servicesall<?php if ($sort == 'servicesall' && $order != 'd') echo '&order=d'; ?>">
				<?php echo _('Sort by All Services'); 
					if ($sort =='servicesall' && $order != 'd')
						echo ' (' . _('Desc') . ')';
				?>
			</a>
		</div>
		<?php echo get_server_status_refresh() ?>
		<div class="clear"></div>
	</div>
	<?php

	global $dashlets;
	$tactical_overview_dashlet = empty($dashlets['tactical_overview']) ? false : $dashlets['tactical_overview'];

	if (!$tactical_overview_dashlet)
		exit();

	// show tactical overview dashlet for all servers!
	{
		$all_servers_dashlet = $tactical_overview_dashlet;
		$all_servers_title = _('Tactical Overview for All Servers');
		$all_servers_dashlet[DASHLET_PARAMS] = array();
		$all_servers_dashlet[DASHLET_PARAMS]['server']['val'] = 'all';
		$all_servers_dashlet[DASHLET_TITLE] = $all_servers_title;

		echo '<div style="margin: 30px 20px 20px">';
		echo "<h2>$all_servers_title</h2>";
		echo get_inline_dashlet_html($all_servers_dashlet);
		echo '</div>';
	}

	$servers = get_servers();

	// if we have a sort option we need to reorganize..
	if ($sort)
		tactical_overview_sort_servers($servers, $sort);

	foreach ($servers as $server) {

		// We currently have nothing to show here for NLS or NNA, so don't show it
		if (in_array($server['server_type'], array(SERVER_TYPE_NLS, SERVER_TYPE_NNA))) {
			continue;
		} 
		
		$dashlet = $tactical_overview_dashlet;
		$dashlet_title = _('Tactical Overview for') . ' ' . $server['name'];
		$dashlet[DASHLET_PARAMS] = array();
		$dashlet[DASHLET_PARAMS]['server']['val'] = $server['server_id'];
		$dashlet[DASHLET_TITLE] = $dashlet_title;
	
		echo '<div style="margin: 30px 20px 20px">';
		echo "<h2>$dashlet_title</h2>";
		echo get_inline_dashlet_html($dashlet);
		echo '</div>';
	}
}

// sort servers depending on the links provided
// options are alpha, hostsup, servicesup, hostsall, servicesall
function tactical_overview_sort_servers(&$servers, $sort) {

	switch($sort) {

		case 'alpha':
			usort($servers, 'tactical_overview_sort_alpha');
			break;

		case 'hostsup':
			usort($servers, 'tactical_overview_sort_hostsup');
			break;

		case 'servicesok':
			usort($servers, 'tactical_overview_sort_servicesok');
			break;

		case 'hostsall':
			usort($servers, 'tactical_overview_sort_hostsall');
			break;

		case 'servicesall':
			usort($servers, 'tactical_overview_sort_servicesall');
			break;
	}
}

function tactical_overview_sort_alpha($a, $b) {

	if (isset($a['name']) && isset($b['name'])) {

		// are we descending?
		$order = grab_request_var('order');
		if ($order == 'd')
			return strcmp($b['name'], $a['name']);

		return strcmp($a['name'], $b['name']);
	}

	return false;
}


function tactical_overview_sort_polled_key($a, $b, $key) {

	if (!$a || !$b)
		return false;

	$a = get_server_polled_key($a, $key, 1);
	$b = get_server_polled_key($b, $key, 1);

	if (!is_array($a) || !is_array($b))
		return false;

	if (!isset($a[0]) || !isset($b[0]))
		return false;

	$a = $a[0];
	$b = $b[0];

	if (!isset($a[$key]) || !isset($b[$key]))
		return false;

	// are we descending?
	$order = grab_request_var('order');
	if ($order == 'd') {
		return $a[$key] < $b[$key];
	}

	return $a[$key] > $b[$key];
}

function tactical_overview_sort_hostsup($a, $b) {
	return tactical_overview_sort_polled_key($a, $b, 'hosts_up');
}

function tactical_overview_sort_hostsall($a, $b) {
	return tactical_overview_sort_polled_key($a, $b, 'hosts_count');
}

function tactical_overview_sort_servicesok($a, $b) {
	return tactical_overview_sort_polled_key($a, $b, 'services_ok');
}

function tactical_overview_sort_servicesall($a, $b) {
	return tactical_overview_sort_polled_key($a, $b, 'services_count');
}

