<?php
require_once(dirname(__FILE__) . '/../component-helper.inc.php');

route_request();
function route_request() {

    $update = grab_request_var('update');
    if (!empty($update))
        home_page_modification_update_user_opts();

    home_page_modification_show_user_opts();
}

function home_page_modification_get_dashboard_url($dashboard_id) {

    return get_base_url(false) . 'dashboards/dashboard.php?id=' . $dashboard_id;
}

function home_page_modification_update_user_opts() {

    $home_page_modification_admin_options = get_array_option('home_page_modification_admin_options', null);

    $allow_title_override         = grab_array_var($home_page_modification_admin_options, 'allow_title_override', true);
    $allow_destination_override   = grab_array_var($home_page_modification_admin_options, 'allow_destination_override', true);

    $title                      = grab_request_var('title', HOME_PAGE_TITLE_DEFAULT);
    $title_custom               = grab_request_var('title_custom', '');
    $destination                = grab_request_var('destination', HOME_PAGE_DEST_DEFAULT);
    $destination_custom         = grab_request_var('destination_custom', '');

    // most of this is self explanatory
    // unless they chose a dashboard
    // then we need to make sure that the appropriate dashboard id info gets put in destination_custom field
    if (strpos($destination, 'dashboard_id_') === 0) {

        $dashboard_id = intval(substr($destination, strlen('dashboard_id_')));

        if ($dashboard_id > 0) {
            $destination = HOME_PAGE_DEST_DASHBOARD;
            $destination_custom = home_page_modification_get_dashboard_url($dashboard_id);
        }
    }

    if ($title != HOME_PAGE_TITLE_CUSTOM)
        $title_custom = '';

    if ($destination != HOME_PAGE_DEST_CUSTOM && $destination != HOME_PAGE_DEST_DASHBOARD)
        $destination_custom = '';

    $home_page_modification_user_options = array();

    if (is_admin() || $allow_title_override) {
        $home_page_modification_user_options['title'] = $title;
        $home_page_modification_user_options['title_custom'] = $title_custom;
    }

    if (is_admin() || $allow_destination_override) {
        $home_page_modification_user_options['destination'] = $destination;
        $home_page_modification_user_options['destination_custom'] = $destination_custom;        
    }

    $home_page_modification_user_options = pack_array($home_page_modification_user_options);

    if (set_user_meta('home_page_modification_user_options', $home_page_modification_user_options))
        flash_message(_('Home Page Settings updated successfully!'));
    else
        flash_message(_('Something went wrong updating Home Page Settings.'));
}

function home_page_modification_show_user_opts() {

    $title = _('User Home Page Settings');
    child_page($title, 'account');

    echo well_top_page_header($title);

    $home_page_modification_admin_options = get_array_option('home_page_modification_admin_options', null);
    $home_page_modification_user_options = unpack_array(get_user_meta('home_page_modification_user_options', null));

    $allow_title_override         = grab_array_var($home_page_modification_admin_options, 'allow_title_override', true);
    $allow_destination_override   = grab_array_var($home_page_modification_admin_options, 'allow_destination_override', true);

    // if we aren't an admin, and no overrides are allowed, there is no reason to be here
    if (!is_admin() && !$allow_title_override && !$allow_destination_override) {

        echo '<p>' . _('Sorry about that! It looks like your system administrator has disabled the ability for you to override your home page settings. Please contact the administrator for more details.') . '</p>';
        exit();
    }

    $title                      = grab_array_var($home_page_modification_user_options, 'title', HOME_PAGE_TITLE_DEFAULT);
    $title_custom               = grab_array_var($home_page_modification_user_options, 'title_custom', '');
    $destination                = grab_array_var($home_page_modification_user_options, 'destination', HOME_PAGE_DEST_DEFAULT);
    $destination_custom         = grab_array_var($home_page_modification_user_options, 'destination_custom', '');

    $tr_title_custom_initial_style = '';
    if ($title != HOME_PAGE_TITLE_CUSTOM)
        $tr_title_custom_initial_style = ' style="display: none;" ';

    $tr_destination_custom_initial_style = '';
    if ($destination != HOME_PAGE_DEST_CUSTOM)
        $tr_destination_custom_initial_style = ' style="display: none;" ';

    ?>
    <script type="text/javascript">
        $(function() {
            $("#title").change(function() {
                if ($(this).val() == "<?php echo HOME_PAGE_TITLE_CUSTOM; ?>") {
                    $("#tr_title_custom").show();
                } else {
                    $("#tr_title_custom").hide();
                }
            });
            $("#destination").change(function() {
                if ($(this).val() == "<?php echo HOME_PAGE_DEST_CUSTOM; ?>") {
                    $("#tr_destination_custom").show();
                } else {
                    $("#tr_destination_custom").hide();
                }
            });
        });
    </script>

    <p><?php echo _('Use the home page settings to customize your home page landing screen.'); ?></p>
                
    <h5 class="ul"><?php echo _('Home Page Settings'); ?></h5>

    <form method="post"  action="?update"  class="formbuilder" >
        <div class="formbuilder-div formbuilder" >
            <table class="table table-condensed table-no-border table-auto-width">

            <?php if (is_admin() || $allow_title_override) { ?>
                <tr>
                    <td class="vt" style="width: 220px;">
                        <label for="title"><?php echo _('Home Page Title'); ?>:</label>
                    </td>
                    <td>
                        <select name="title" id="title" class="form-control">
                            <option value="<?php echo HOME_PAGE_TITLE_DEFAULT; ?>" <?php is_selected($title, HOME_PAGE_TITLE_DEFAULT); ?>><?php echo _('Default Value'); ?></option>
                            <option value="<?php echo HOME_PAGE_TITLE_CUSTOM; ?>" <?php is_selected($title, HOME_PAGE_TITLE_CUSTOM); ?>><?php echo _('Custom Value'); ?></option>
                        </select>
                        <div class="subtext"><?php echo _('Used to override the default home page title.'); ?></div>
                    </td>
                </tr>
                <tr id="tr_title_custom" <?php echo $tr_title_custom_initial_style; ?>>
                    <td class="vt">
                        <label for="title_custom"><?php echo _('Custom Home Page Title'); ?>:</label>
                    </td>
                    <td>
                        <input type="title_custom" size="40" name="title_custom" id="title_custom" value="<?php echo encode_html($title_custom); ?>" class="form-control">
                        <div class="subtext"><?php echo _('Used to override the default home page title.'); ?></div>
                    </td>
                </tr>
            <?php } // allow title override ?>

            <?php if (is_admin() || $allow_destination_override) { ?>
                <tr>
                    <td class="vt">
                        <label for="destination"><?php echo _('Home Page Destination'); ?>:</label>
                    </td>
                    <td>
                        <select name="destination" id="destination" class="form-control">
                            <option value="<?php echo HOME_PAGE_DEST_DEFAULT; ?>" <?php is_selected($destination, HOME_PAGE_DEST_DEFAULT); ?>><?php echo _('Default (Static)'); ?></option>
                            <option value="<?php echo HOME_PAGE_DEST_STATIC; ?>" <?php is_selected($destination, HOME_PAGE_DEST_STATIC); ?>><?php echo _('Static Home Page'); ?></option>
                            <option value="<?php echo HOME_PAGE_DEST_HOME_DASHBOARD; ?>" <?php is_selected($destination, HOME_PAGE_DEST_HOME_DASHBOARD); ?>><?php echo _('Home Dashboard'); ?></option>
                            <option value="<?php echo HOME_PAGE_DEST_CUSTOM; ?>" <?php is_selected($destination, HOME_PAGE_DEST_CUSTOM); ?>><?php echo _('Custom Destination'); ?></option>
                            <?php

                            // we also give the end user the ability to select a different dashboard for their home pages
                            $dashboards = get_dashboards(0, $screen = 0, $home = 0);
                            if (count($dashboards) > 0) {

                                echo '<option value="dashboard_spacer">-- ' . _('Dashboards') . " --</option>\n";
                                foreach ($dashboards as $dashboard) {
                                    if ($dashboard['show_in_menu'] && !$dashboard['screen']) {

                                        $selected = '';
                                        if ($destination == HOME_PAGE_DEST_DASHBOARD)
                                            $selected = is_selected($destination_custom, home_page_modification_get_dashboard_url($dashboard['dashboard_id']), false);

                                        echo '<option value="dashboard_id_' . $dashboard['dashboard_id'] . ' "' . $selected . ' >' . $dashboard['dashboard_name'] . "</option>\n";
                                    }
                                }
                            }

                            ?>
                        </select>
                        <div class="subtext"><?php echo _('Where the home page should be redirected to.'); ?></div>
                    </td>
                </tr>
                <tr id="tr_destination_custom" <?php echo $tr_destination_custom_initial_style; ?>>
                    <td class="vt">
                        <label for="destination_custom"><?php echo _('Custom Destination URL'); ?>:</label>
                    </td>
                    <td>
                        <input type="destination_custom" size="40" name="destination_custom" id="destination_custom" value="<?php echo encode_html($destination_custom); ?>" class="form-control">
                        <div class="subtext"><?php echo _('The custom URL to use as the home page destination.'); ?></div>
                    </td>
                </tr>
            <?php } // allow dest override ?>

            </table>
        <div class="clear"></div>
        <div class="formbuilder-buttons">
            <input name="update"  value="<?php echo _('Update Information'); ?>"  class="btn btn-primary btn-sm"  type="submit"  />
            <a name="cancel" value="<?php echo _('Cancel'); ?>" class="btn btn-default btn-sm cancel-validator" href="/nagiosfusion/" target="_top"> Cancel </a>

        </div>
    </form>

    <?php
}