<?php

register_home_page_modification();
function register_home_page_modification() {

    $component_args = array(

        COMPONENT_NAME              => 'home_page_modification',
        COMPONENT_TITLE             => _('Home Page Modification'),
        COMPONENT_VERSION           => '4.0.1',
        COMPONENT_DATE              => '10/04/2017',
        COMPONENT_AUTHOR            => 'Nagios Enterprises, LLC',
        COMPONENT_DESCRIPTION       => _('Allows system administrators and users to customize the home page landing screen.'),
        COMPONENT_REQUIRES_VERSION  => 3990,
        COMPONENT_CONFIG_FUNCTION   => 'home_page_modification_config_func',

        COMPONENT_FUNCTION          => 'home_page_modification_successful_registration',
    );

    register_component($component_args);
}


function home_page_modification_successful_registration() {

        define('HOME_PAGE_TITLE_DEFAULT',           'title_default');
        define('HOME_PAGE_TITLE_CUSTOM',            'title_custom');
        define('HOME_PAGE_DEST_DEFAULT',            'dest_default');
        define('HOME_PAGE_DEST_STATIC',             'dest_static');
        define('HOME_PAGE_DEST_HOME_DASHBOARD',     'dest_home_dashboard');
        define('HOME_PAGE_DEST_CUSTOM',             'dest_custom');
        define('HOME_PAGE_DEST_DASHBOARD',          'dest_dashboard');

        register_callback(CALLBACK_HOME_PAGE, 'home_page_modification_callback');
        register_callback(CALLBACK_MENU_INITIALIZED, 'home_page_modification_menu_items');
}


function home_page_modification_menu_items($cb, &$menu) {

    $menu->add_link_spacer('account-details');
    $menu->add_link(menu_link(_('Home Page Settings'), get_components_base_url() . 'home_page_modification/home_page_mod_useropts.php'), 'account-details');

    if (is_admin()) {
        $menu->add_link_spacer('admin-system-extensions');
        $menu->add_link(menu_link(_('Home Page Defaults'), get_base_url() . 'admin/components.php?config=home_page_modification'), 'admin-system-extensions');
    }
}


function home_page_modification_config_func($mode = null) {

    $output = '';

    switch ($mode) {

        case COMPONENT_CONFIG_MODE_GET:

            $home_page_modification_admin_options = get_array_option('home_page_modification_admin_options', null);

            $title                      = grab_array_var($home_page_modification_admin_options, 'title', HOME_PAGE_TITLE_DEFAULT);
            $title_custom               = grab_array_var($home_page_modification_admin_options, 'title_custom', '');
            $allow_title_override       = grab_array_var($home_page_modification_admin_options, 'allow_title_override', true);
            $destination                = grab_array_var($home_page_modification_admin_options, 'destination', HOME_PAGE_DEST_DEFAULT);
            $destination_custom         = grab_array_var($home_page_modification_admin_options, 'destination_custom', '');
            $allow_destination_override = grab_array_var($home_page_modification_admin_options, 'allow_destination_override', true);

            // is this postback?
            if (grab_request_var('title') !== null) {

                $title                      = grab_request_var('title', $title);
                $title_custom               = grab_request_var('title_custom', $title_custom);
                $allow_title_override       = grab_request_var('allow_title_override', $allow_title_override);
                $destination                = grab_request_var('destination', $destination);
                $destination_custom         = grab_request_var('destination_custom', $destination_custom);
                $allow_destination_override = grab_request_var('allow_destination_override', $allow_destination_override);

            }

            $tr_title_custom_initial_style = '';
            if ($title != HOME_PAGE_TITLE_CUSTOM)
                $tr_title_custom_initial_style = ' style="display: none;" ';

            $tr_destination_custom_initial_style = '';
            if ($destination != HOME_PAGE_DEST_CUSTOM)
                $tr_destination_custom_initial_style = ' style="display: none;" ';

            $output = '
                <script type="text/javascript">
                    $(function() {
                        $("#title").change(function() {
                            if ($(this).val() == "' . HOME_PAGE_TITLE_CUSTOM . '") {
                                $("#tr_title_custom").show();
                            } else {
                                $("#tr_title_custom").hide();
                            }
                        });
                        $("#destination").change(function() {
                            if ($(this).val() == "' . HOME_PAGE_DEST_CUSTOM . '") {
                                $("#tr_destination_custom").show();
                            } else {
                                $("#tr_destination_custom").hide();
                            }
                        });
                    });
                </script>            

                <p>' . _('Use the home page modification component choose the system defaults for the home page landing screen and title. You can also use this tool to override user settings, enforcing the home page they see when they log in to Nagios Fusion.') . '</p>
                            
                <h5 class="ul">' . _('Home Page Modification Administration') . '</h5>

                <table class="table table-condensed table-no-border table-auto-width">


                    <tr>
                        <td class="vt" style="width: 38%;">
                            <label for="title">' . _('Home Page Title') . ':</label>
                        </td>
                        <td>
                            <select name="title" id="title" class="form-control">
                                <option value="' . HOME_PAGE_TITLE_DEFAULT . '" ' . is_selected($title, HOME_PAGE_TITLE_DEFAULT, false) . '>' . _('Default Value') . '</option>
                                <option value="' . HOME_PAGE_TITLE_CUSTOM . '" ' . is_selected($title, HOME_PAGE_TITLE_CUSTOM, false) . '>' . _('Custom Value') . '</option>
                            </select>
                            <div class="subtext">' . _('Used to override the default home page title.') . '</div>
                        </td>
                    </tr>
                    <tr id="tr_title_custom" ' . $tr_title_custom_initial_style . '>
                        <td class="vt">
                            <label for="title_custom">' . _('Custom Home Page Title') . ':</label>
                        </td>
                        <td>
                            <input type="title_custom" size="40" name="title_custom" id="title_custom" value="' . encode_html($title_custom) . '" class="form-control">
                            <div class="subtext">' . _('Used to override the default home page title.') . '</div>
                        </td>
                    </tr>
                    <tr>
                        <td></td>
                        <td class="checkbox">
                            <label>
                                <input type="checkbox" value="1"  class="checkbox" id="enabled" name="allow_title_override" ' . is_checked($allow_title_override, true, false) . '>
                                ' . _('Allow users to override their default home page title.') . '
                            </label>
                        </td>
                    </tr>
                    <tr>
                        <td class="vt">
                            <label for="destination">' . _('Home Page Destination') . ':</label>
                        </td>
                        <td>
                            <select name="destination" id="destination" class="form-control">
                                <option value="' . HOME_PAGE_DEST_DEFAULT . '" ' . is_selected($destination, HOME_PAGE_DEST_DEFAULT, false) . '>' . _('Default (Static)') . '</option>
                                <option value="' . HOME_PAGE_DEST_STATIC . '" ' . is_selected($destination, HOME_PAGE_DEST_STATIC, false) . '>' . _('Static Home Page') . '</option>
                                <option value="' . HOME_PAGE_DEST_HOME_DASHBOARD . '" ' . is_selected($destination, HOME_PAGE_DEST_HOME_DASHBOARD, false) . '>' . _('Home Dashboard') . '</option>
                                <option value="' . HOME_PAGE_DEST_CUSTOM . '" ' . is_selected($destination, HOME_PAGE_DEST_CUSTOM, false) . '>' . _('Custom Destination') . '</option>
                            </select>
                            <div class="subtext">' . _('Where the home page should be redirected to.') . '</div>
                        </td>
                    </tr>
                    <tr id="tr_destination_custom" ' . $tr_destination_custom_initial_style . '>
                        <td class="vt">
                            <label for="destination_custom">' . _('Custom Destination URL') . ':</label>
                        </td>
                        <td>
                            <input type="destination_custom" size="40" name="destination_custom" id="destination_custom" value="' . encode_html($destination_custom) . '" class="form-control">
                            <div class="subtext">' . _('The custom URL to use as the home page destination.') . '</div>
                        </td>
                    </tr>
                    <tr>
                        <td></td>
                        <td class="checkbox">
                            <label>
                                <input type="checkbox" value="1" class="checkbox" id="enabled" name="allow_destination_override" ' . is_checked($allow_destination_override, true, false) . '>
                                ' . _('Allow users to override their default home page destination.') . '
                            </label>
                        </td>
                    </tr>
                </table>';
            break;

        case COMPONENT_CONFIG_MODE_SET:

            $home_page_modification_admin_options = get_array_option('home_page_modification_admin_options', null);

            $title                      = grab_request_var('title', HOME_PAGE_TITLE_DEFAULT);
            $title_custom               = grab_request_var('title_custom', '');
            $allow_title_override       = grab_request_var('allow_title_override', false);
            $destination                = grab_request_var('destination', HOME_PAGE_DEST_DEFAULT);
            $destination_custom         = grab_request_var('destination_custom', '');
            $allow_destination_override = grab_request_var('allow_destination_override', false);

            $home_page_modification_admin_options = array(
                'title'                         => $title,
                'title_custom'                  => $title_custom,
                'allow_title_override'          => $allow_title_override,
                'destination'                   => $destination,
                'destination_custom'            => $destination_custom,
                'allow_destination_override'    => $allow_destination_override,
                );

            set_array_option('home_page_modification_admin_options', $home_page_modification_admin_options);

            return true;

            break;
    }

    return $output;
}


function home_page_modification_callback($cb, &$cbargs) {

    // check to see if we need to modify the home page
    if ($cb == CALLBACK_HOME_PAGE) {

        /* logic is applied like this:
        if user_opts are specified and user is admin, use the user_opts
        if user_opts are specified and user is not admin, make sure that the appropriate override settings are set
            -> if they are, then use those user_opts
            -> if they arem't. then use the admin_opts (if set)
        if no user_opts, but there are admin_opts, use those
        if no user_opts and no admin_opts, we do nothing
        */

        // grab the options
        $h_user_opts = unpack_array(get_user_meta('home_page_modification_user_options', null));
        $h_admin_opts = get_array_option('home_page_modification_admin_options', null);

        // bail out quick if we don't have either
        if (!is_array($h_user_opts) && !is_array($h_admin_opts))
            return $cbargs;

        // the defaults
        $title = '';
        $product_in_page_title = true;
        $iframe_src = 'main.php';

        $a_title                        = grab_array_var($h_admin_opts, 'title', HOME_PAGE_TITLE_DEFAULT);
        $a_title_custom                 = grab_array_var($h_admin_opts, 'title_custom', '');
        $a_allow_title_override         = grab_array_var($h_admin_opts, 'allow_title_override', true);
        $a_destination                  = grab_array_var($h_admin_opts, 'destination', HOME_PAGE_DEST_DEFAULT);
        $a_destination_custom           = grab_array_var($h_admin_opts, 'destination_custom', '');
        $a_allow_destination_override   = grab_array_var($h_admin_opts, 'a_allow_destination_override', true);

        $u_title                        = grab_array_var($h_user_opts, 'title', HOME_PAGE_TITLE_DEFAULT);
        $u_title_custom                 = grab_array_var($h_user_opts, 'title_custom', '');
        $u_destination                  = grab_array_var($h_user_opts, 'destination', HOME_PAGE_DEST_DEFAULT);
        $u_destination_custom           = grab_array_var($h_user_opts, 'destination_custom', '');

        // if user is admin or admin allowed the title to be overridden then check for custom value
        if (is_admin() || $a_allow_title_override) {
            if ($u_title == HOME_PAGE_TITLE_CUSTOM && !empty($u_title_custom)) {
                $title = $u_title_custom;
                $product_in_page_title = false;
            }
        }

        // if title is set to default check if there is an admin default
        if ($u_title == HOME_PAGE_TITLE_DEFAULT) {
            if ($a_title == HOME_PAGE_TITLE_CUSTOM && !empty($a_title_custom)) {
                $title = $a_title_custom;
                $product_in_page_title = false;
            }
        }

        // defaults we will use for determining the home page dest
        $destination = null;
        $destination_custom = null;

        // if user is admin or admin allowed dest to be overriden then set this to the values
        if (is_admin() || $a_allow_destination_override) {
            if ($u_destination != HOME_PAGE_DEST_DEFAULT) {
                $destination = $u_destination;
                $destination_custom = $u_destination_custom;
            }
        }

        // if we haven't already set the dest, check if user dest is default
        // and then overwrite our dest with admin values
        if ($destination === null) {
            if ($u_destination == HOME_PAGE_DEST_DEFAULT) {
                $destination = $a_destination;
                $destination_custom = $a_destination_custom;
            }
        }

        // now actually calculate the home page
        switch($destination) {

            case HOME_PAGE_DEST_HOME_DASHBOARD:
                $iframe_src = get_base_url(false) . 'dashboards/home.php';
                break;

            case HOME_PAGE_DEST_CUSTOM:
                set_option('home_page_url', $destination_custom);
                $iframe_src = get_base_url(false) . 'includes/custom-home-page.php';
                break;

            case HOME_PAGE_DEST_DASHBOARD:
                $iframe_src = $destination_custom;
                break;

            case HOME_PAGE_DEST_STATIC:
            case HOME_PAGE_DEST_DEFAULT:
            default:

                $iframe_src = 'main.php';
                break;
        }

        if (!empty($title))
            $cbargs['page_title'] = $title;
        
        $cbargs['product_in_page_title'] = $product_in_page_title;
        $cbargs['iframe_src'] = $iframe_src;

    } // if callback == callback_home_page

    return $cbargs;
}
