<?php
require_once(dirname(__FILE__) . '/../../component-helper.inc.php');

dashlets_data_check();

open_host_problems_dashlet();
function open_host_problems_dashlet() {

    $server = grab_request_var('server');
    $acknowledgements = intval(grab_request_var('acknowledgements'));
    $limit = intval(grab_request_var('limit', NOC_DEFAULT_LIMIT));

    $data = array();

    if ($server !== 'all') {
        $server = intval($server);
        $data = open_host_problems_get_server_data($server, $acknowledgements);
    } else {
        $servers = get_servers();
        foreach ($servers as $this_server) {
            $this_data = open_host_problems_get_server_data($this_server, $acknowledgements);
            if (is_array($this_data))
                $data = array_merge($data, $this_data);
        }
    }

    if (!empty($data)) {
        ksort($data, SORT_STRING);
    }
    ?>
    <strong><?php echo noc_component_get_message($acknowledgements); ?></strong>
    <div class='dashlet_wrapper'>
        <table class="host_status_summary_dashlet infotable table table-condensed table-striped table-bordered">
            <thead class='scrollable_dashlet_sticky_header'>
                <tr>
                    <th><?php echo _('Server'); ?></th>
                    <th><?php echo _('Host'); ?></th>
                    <th><?php echo _('Acknowledged'); ?></th>
                    <th><?php echo _('Output'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $count = 0;
                    if (!empty($data)) {
                        foreach ($data as $server => $host_data) {
                            foreach ($host_data as $host => $host_array) {

                                if ($count++ >= $limit)
                                    break;

                                $hostclass = 'up';
                                switch ($host_array['current_state']) {          
                                    case STATE_DOWN:        $hostclass = 'down';            break;
                                    case STATE_UNREACHABLE: $hostclass = 'unreachable';     break;
                                }
                                $hostclass = ' class="havehost' . $hostclass . '"';

                                $server_link = get_server_base_url($server, $core_include_cgi = false);
                                $server_link = '<a href="' . $server_link . '" target="_blank">' . $server . '</a>';

                                $host_link = get_tactical_link($host, $server, 
                                    "includes/components/xicore/status.php?show=hostdetail&host=" . urlencode($host),
                                    "extinfo.cgi?type=1&host=" . urlencode($host));

                                echo
                                    '<tr>' .
                                    '<td>' . $server_link . '</td>' .
                                    '<td' . $hostclass . '>' . $host_link . '</td>' .
                                    '<td>' . noc_component_convert_acknowledgement($host_array['acknowledged']) . '</td>' .
                                    '<td>' . $host_array['output'] . '</td>' .
                                    '</tr>';
                            }
                        }
                    }
                ?>
            </tbody>
        </table>
    </div>
    <?php
}

function open_host_problems_get_server_data($server, $acknowledgements) {

    $server = get_server($server);
    if ($server === false)
        return false;

    $host_data = get_server_polled_key($server, 'host_status', $key_limit = 1);
    if (!isset($host_data[0]['host_status']))
        return false;

    $server_data = array();

    $host_data = unpack_array($host_data[0]['host_status']);
    foreach ($host_data as $host => $host_array) {

        if ($host_array['current_state'] == STATE_UP) {
            unset($host_data[$host]);
            continue;
        }

        $add_to_array = false;

        switch ($acknowledgements) {

            case ACK_SHOW_UNHANDLED:
                if ($host_array['acknowledged'] == 0 && $host_array['downtime'] == 0)
                    $add_to_array = true;
                break;

            case ACK_SHOW_ACKNOWLEDGED:
                if ($host_array['acknowledged'] == 1)
                    $add_to_array = true;
                break;

            case ACK_SHOW_ALL:
                $add_to_array = true;
                break;
        }

        if ($add_to_array)
            $server_data[$server['name']][$host] = $host_array;
    }

    return $server_data;
}