<?php
require_once(dirname(__FILE__) . '/../../component-helper.inc.php');

dashlets_data_check();

open_problems_summary_dashlet();
function open_problems_summary_dashlet() {

    $server = grab_request_var('server');
    $acknowledgements = grab_request_var('acknowledgements');

    $data = array(
        'hosts_count'                       => 0,
        'hosts_pending'                     => 0,
        'hosts_up'                          => 0,
        'hosts_down'                        => 0,
        'hosts_unreachable'                 => 0,
        'hosts_disabled'                    => 0,
        'hosts_problems'                    => 0,
        'hosts_problems_unhandled'          => 0,
        'hosts_acknowledged'                => 0,
        'hosts_flapping'                    => 0,
        'hosts_downtime'                    => 0,
        'hosts_pending_disabled'            => 0,
        'hosts_up_disabled'                 => 0,
        'hosts_up_downtime'                 => 0,
        'hosts_down_disabled'               => 0,
        'hosts_down_acknowledged'           => 0,
        'hosts_down_downtime'               => 0,
        'hosts_unreachable_disabled'        => 0,
        'hosts_unreachable_acknowledged'    => 0,
        'hosts_unreachable_downtime'        => 0,
        'services_count'                    => 0,
        'services_pending'                  => 0,
        'services_ok'                       => 0,
        'services_warning'                  => 0,
        'services_critical'                 => 0,
        'services_unknown'                  => 0,
        'services_disabled'                 => 0,
        'services_problems'                 => 0,
        'services_problems_unhandled'       => 0,
        'services_acknowledged'             => 0,
        'services_flapping'                 => 0,
        'services_downtime'                 => 0,
        'services_pending_disabled'         => 0,
        'services_ok_disabled'              => 0,
        'services_ok_downtime'              => 0,
        'services_warning_disabled'         => 0,
        'services_warning_acknowledged'     => 0,
        'services_warning_downtime'         => 0,
        'services_critical_disabled'        => 0,
        'services_critical_acknowledged'    => 0,
        'services_critical_downtime'        => 0,
        'services_unknown_disabled'         => 0,
        'services_unknown_acknowledged'     => 0,
        'services_unknown_downtime'         => 0,

        // Modified to provide an accurate and formatted 'Last Updated' time
		// -acoil 2023-17-01
        'polled_time'                       => date("Y-m-d H:i:s", time()),
        );

    // grab an individual servers overview data
    if ($server !== 'all') {
        
        $server = intval($server);

        // only grab the data we need for this server
        $server_data = get_server_data($server);

        if ($server_data !== false && is_array($server_data))
            $data = array_merge($data, $server_data);

    } else {
        
        // aggregate all server data
        $servers = get_servers();
        foreach ($servers as $server) {

            $server_data = get_server_data($server);
            if ($server_data) {

                foreach ($server_data as $key => $value) {
					if (isset($data[$key]) && $key != 'polled_time') {

                        // Needed to add type handling as integers need to be added, but strings cannot
                        // -acoil 2023-17-01
                        if(gettype($data[$key]) == 'integer'){
                            $data[$key] += $value;
                        }
                    } else {
                        if ($key != 'polled_time') {
                            $data[$key] = $value;
                        }
                    }
                }
            }
        }

        $server = 'all';
    }

    $hostdown = 0;
    $hostunreachable = 0;
    $hostproblems = 0;
    $servicewarning = 0;
    $servicecritical = 0;
    $serviceunknown = 0;
    $serviceproblems = 0;

    switch ($acknowledgements) {

        case ACK_SHOW_UNHANDLED:
            $hostdown = $data['hosts_down'] - $data['hosts_down_acknowledged'] - $data['hosts_down_downtime'];
            $hostunreachable = $data['hosts_unreachable'] - $data['hosts_unreachable_acknowledged'] - $data['hosts_unreachable_downtime'];
            $hostproblems =  $data['hosts_problems_unhandled'];
            $servicewarning = $data['services_warning'] - $data['services_warning_acknowledged'] - $data['services_warning_downtime'];
            $servicecritical = $data['services_critical'] - $data['services_critical_acknowledged'] - $data['services_critical_downtime'];
            $serviceunknown = $data['services_unknown'] - $data['services_unknown_acknowledged'] - $data['services_unknown_downtime'];
            $serviceproblems = $data['services_problems_unhandled'];
            break;

        case ACK_SHOW_ACKNOWLEDGED:
            $hostdown = $data['hosts_down_acknowledged'];
            $hostunreachable = $data['hosts_unreachable_acknowledged'];
            $hostproblems =  $data['hosts_acknowledged'];
            $servicewarning = $data['services_warning_acknowledged'];
            $servicecritical = $data['services_critical_acknowledged'];
            $serviceunknown = $data['services_unknown_acknowledged'];
            $serviceproblems = $data['services_acknowledged'];
            break;

        case ACK_SHOW_ALL:
            $hostdown = $data['hosts_down'];
            $hostunreachable = $data['hosts_unreachable'];
            $hostproblems = $data['hosts_problems'];
            $servicewarning = $data['services_warning'];
            $servicecritical = $data['services_critical'];
            $serviceunknown = $data['services_unknown'];
            $serviceproblems = $data['services_problems'];
            break;
    }

    ?>
    <strong><?php echo noc_component_get_message($acknowledgements); ?></strong>
    <table class="host_status_summary_dashlet service_status_summary_dashlet infotable table table-condensed table-striped table-bordered">
        <thead>
            <tr>
                <th></th>
                <th><?php echo _('Down'); ?></th>
                <th><?php echo _('Unreachable'); ?></th>
                <th><?php echo _('All'); ?></th>
                <th></th>
                <th><?php echo _('Warning'); ?></th>
                <th><?php echo _('Critical'); ?></th>
                <th><?php echo _('Unknown'); ?></th>
                <th><?php echo _('All'); ?></th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><strong><?php echo _('Hosts'); ?></strong></td>
                <td class="havehostdown"><?php echo $hostdown; ?></td>
                <td class="havehostunreachable"><?php echo $hostunreachable; ?></td>
                <td class="havehostproblems"><?php echo $hostproblems; ?></td>

                <td><strong><?php echo _('Services'); ?></strong></td>
                <td class="haveservicewarning"><?php echo $servicewarning; ?></td>
                <td class="haveservicecritical"><?php echo $servicecritical; ?></td>
                <td class="haveserviceunknown"><?php echo $serviceunknown; ?></td>
                <td class="haveserviceproblems"><?php echo $serviceproblems; ?></td>
            </tr>
        </tbody>
    </table>
    <div class="ajax_date"><?php echo _("Last Updated"); ?>: <?php echo convert_timestring_to_local_users_time($data['polled_time']); ?></div>
    <?php
}