<?php
require_once(dirname(__FILE__) . '/../../component-helper.inc.php');

dashlets_data_check();

open_service_problems_dashlet();
function open_service_problems_dashlet() {

    $server = grab_request_var('server');
    $acknowledgements = intval(grab_request_var('acknowledgements'));
    $limit = intval(grab_request_var('limit', NOC_DEFAULT_LIMIT));

    $data = array();

    if ($server != 'all') {
        $server = intval($server);
        $data = open_service_problems_get_server_data($server, $acknowledgements);
    } else {
        $servers = get_servers();
        foreach ($servers as $this_server) {
            $this_data = open_service_problems_get_server_data($this_server, $acknowledgements);
            if (is_array($this_data))
                $data = array_merge($data, $this_data);
        }
    }

    if (!empty($data)) {
        ksort($data, SORT_STRING);
    }
    ?>
    <strong><?php echo noc_component_get_message($acknowledgements); ?></strong>
    <div class='dashlet_wrapper'>
        <table class="host_status_summary_dashlet service_status_summary_dashlet infotable table table-condensed table-striped table-bordered">
            <thead class='scrollable_dashlet_sticky_header'>
                <tr>
                    <th><?php echo _('Server'); ?></th>
                    <th><?php echo _('Host'); ?></th>
                    <th><?php echo _('Service'); ?></th>
                    <th><?php echo _('Acknowledged'); ?></th>
                    <th><?php echo _('Output'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $count = 0;
                    if (!empty($data)) {
                        foreach ($data as $server => $svc_data) {
                            foreach ($svc_data as $host => $host_array) {
                                foreach ($host_array as $svc_desc => $svc_array) {

                                    if ($count++ >= $limit)
                                        break;

                                    $hostclass = 'up';
                                    switch ($svc_array['host_state']) {          
                                        case STATE_DOWN:        $hostclass = 'down';            break;
                                        case STATE_UNREACHABLE: $hostclass = 'unreachable';     break;
                                    }
                                    $hostclass = ' class="havehost' . $hostclass . '"';

                                    $svcclass = 'ok';
                                    switch ($svc_array['current_state']) {
                                        case STATE_WARNING:     $svcclass = 'warning';  break;
                                        case STATE_CRITICAL:    $svcclass = 'critical'; break;
                                        case STATE_UNKNOWN:     $svcclass = 'unknown';  break;
                                    }
                                    $svcclass = ' class="haveservice' . $svcclass . '"';

                                    $server_link = get_server_base_url($server, $core_include_cgi = false);
                                    $server_link = '<a href="' . $server_link . '" target="_blank">' . $server . '</a>';

                                    $host_link = get_tactical_link($host, $server, 
                                    "includes/components/xicore/status.php?show=hostdetail&host=" . urlencode($host),
                                    "extinfo.cgi?type=1&host=" . urlencode($host));

                                    $service_link = get_tactical_link($svc_desc, $server,
                                        "includes/components/xicore/status.php?show=servicedetail&dest=auto&host=" . urlencode($host) . "&service=" . urlencode($svc_desc),
                                        "extinfo.cgi?type=2&host=" . urlencode($host) . "&service=" . urlencode($svc_desc));

                                    echo
                                        '<tr>' .
                                        '<td>' . $server_link . '</td>' .
                                        '<td' . $hostclass . '>' . $host_link . '</td>' .
                                        '<td' . $svcclass . '>' . $service_link . '</td>' .
                                        '<td>' . noc_component_convert_acknowledgement($svc_array['acknowledged']) . '</td>' .
                                        '<td>' . $svc_array['output'] . '</td>' .
                                        '</tr>';
                                }
                            }
                        }
                    }
                ?>
            </tbody>
        </table>
    </div>
    <?php
}

function open_service_problems_get_server_data($server, $acknowledgements) {

    $server = get_server($server);
    if ($server === false)
        return false;

    $host_data = get_server_polled_key($server, 'host_status', $key_limit = 1);
    if (!isset($host_data[0]['host_status']))
        return false;

    $svc_data = get_server_polled_key($server, 'service_status', $key_limit = 1);
    if (!isset($svc_data[0]['service_status']))
        return false;

    $server_data = array();

    $host_data = unpack_array($host_data[0]['host_status']);
    $svc_data = unpack_array($svc_data[0]['service_status']);
    foreach ($svc_data as $host => $host_array) {
        foreach ($host_array as $svc_desc => $svc_array) {

            if ($svc_array['current_state'] == STATE_UP) {
                unset($svc_data[$host][$svc_desc]);
                continue;
            }

            // lets append some data
            $add_to_array = false;
            $svc_array['host_state'] = !empty($host_data[$host]['current_state']) ? $host_data[$host]['current_state'] : 0;

            switch ($acknowledgements) {

                case ACK_SHOW_UNHANDLED:
                    if ($svc_array['acknowledged'] == 0 && $svc_array['downtime'] == 0)
                        $add_to_array = true;
                    break;

                case ACK_SHOW_ACKNOWLEDGED:
                    if ($svc_array['acknowledged'] == 1)
                        $add_to_array = true;
                    break;

                case ACK_SHOW_ALL:
                    $add_to_array = true;
                    break;
            }

            if ($add_to_array)
                $server_data[$server['name']][$host][$svc_desc] = $svc_array;
        }
    }

    return $server_data;
}