<?php

register_noc();
function register_noc() {

    $component_args = array(

        COMPONENT_NAME              => 'noc',
        COMPONENT_TITLE             => _('Network Operations Center'),
        COMPONENT_VERSION           => '4.1.5',
        COMPONENT_AUTHOR            => 'Nagios Enterprises, LLC',
        COMPONENT_DESCRIPTION       => _('Display open host and service problems across your Fused network.'),
        COMPONENT_REQUIRES_VERSION  => 5100,

        COMPONENT_FUNCTION          => 'noc_successful_registration',
    );

    register_component($component_args);
}

function noc_successful_registration() {

    // these are filter options we use for the dashlets we register
    define('NOC_DEFAULT_LIMIT',     10);
    define('ACK_SHOW_UNHANDLED',    0);
    define('ACK_SHOW_ACKNOWLEDGED', 1);
    define('ACK_SHOW_ALL',          2);

    require_once(dirname(__FILE__) . '/dashlets/open_host_problems.inc.php');
    require_once(dirname(__FILE__) . '/dashlets/open_service_problems.inc.php');
    require_once(dirname(__FILE__) . '/dashlets/open_problems_summary.inc.php');

    register_callback(CALLBACK_MENU_INITIALIZED, 'register_noc_menu');
}

function register_noc_menu($cb, &$menu) {

    $menu->add_link(menu_link(_('Network Operations Center'), 'includes/components/noc/noc.php'), 'home-server-status');
}

// the dashlet params are the same for all of the dashlets we include
function noc_component_dashlet_params() {
    
    $servers = array('all' => _('All Servers'));
    foreach (get_servers() as $server) {
        $servers[$server['server_id']] = $server['name'];
    }

    return array(

        'server' => array(
            'name'      => _('Server'),
            'options'   => $servers, // in the format of array(val => humanreadable)
            ), 

        'acknowledgements' => array(
            'name'      => _('Filter Acknowledgements'),
            'options'   => array(
                ACK_SHOW_UNHANDLED      => _('Show Unhandled'),
                ACK_SHOW_ACKNOWLEDGED   => _('Show Acknowledged'),
                ACK_SHOW_ALL            => _('Show Both'),
                ),
            ),
        );
}

function noc_component_dashlet_params_with_limit() {

    $params = noc_component_dashlet_params();

    $params['limit'] = array(
        'name'  => _('Problem Display Limit'),
        'val'   => NOC_DEFAULT_LIMIT,
        );

    return $params;
}


function noc_component_convert_acknowledgement($ack) {

    if ($ack)
        return _('Yes');

    return _('No');
}

function noc_component_get_message($ack) {

    switch ($ack) {

        case ACK_SHOW_UNHANDLED:
            return _('Showing unhandled problems');
            break;

        case ACK_SHOW_ACKNOWLEDGED:
            return _('Showing acknowledged problems');
            break;

        case ACK_SHOW_ALL:
            return _('Showing all problems');
            break;
    }

    return '';
}