<?php
require_once(dirname(__FILE__) . '/../component-helper.inc.php');

sysstat();
function sysstat() {

    // if we are just updating the ack_filter, we jsut do that then exit
    $cmd = grab_request_var('cmd');
    if ($cmd == 'update') {
        
        $ack_filter = grab_request_var('ack_filter');
        if ($ack_filter !== null)
            set_option('noc_ack_filter', $ack_filter);

        exit();
    }

    $title = _('Network Operations Center');
    child_page($title);

    $ack_filter = get_option('noc_ack_filter');
    if ($ack_filter != ACK_SHOW_ACKNOWLEDGED && $ack_filter != ACK_SHOW_ALL)
        $ack_filter = ACK_SHOW_UNHANDLED;

    $filter = '
        <div class="fl" style="line-height: 24px; margin-left: 24px;">
            <select id="ack_filter" class="form-control">
                <option value="' . ACK_SHOW_UNHANDLED . '" ' . is_selected($ack_filter, ACK_SHOW_UNHANDLED, false) . '>' . _('Show Unhandled') . '</option>
                <option value="' . ACK_SHOW_ACKNOWLEDGED . '" ' . is_selected($ack_filter, ACK_SHOW_ACKNOWLEDGED, false) . '>' . _('Show Acknowledged') . '</option>
                <option value="' . ACK_SHOW_ALL . '" ' . is_selected($ack_filter, ACK_SHOW_ALL, false) . '>' . _('Show All') . '</option>
            </select>
        </div>
        '. get_server_status_refresh() .'
    ';

    echo well_top_page_header($title, $filter);

    global $dashlets;

    $open_host_problems     = empty($dashlets['open_host_problems']) ? false : $dashlets['open_host_problems'];
    $open_service_problems  = empty($dashlets['open_service_problems']) ? false : $dashlets['open_service_problems'];
    $open_problems_summary  = empty($dashlets['open_problems_summary']) ? false : $dashlets['open_problems_summary'];

    ?>
    <div class="container-fluid" style="margin: 10px -10px;">
        <div class="row">
            <div class="col-sm-12 col-md-8 col-lg-7 col-xl-6">
    <?php

    if (!empty($open_problems_summary)) {
        echo '<div style="margin: 20px 30px 0 30px;">';
        echo '<h2>' . _('Open Problems Summary') . '</h2>';
        echo get_inline_dashlet_html($open_problems_summary, true);
        echo '</div>';
    }

    ?>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
    <?php

    if (!empty($open_host_problems)) {
        echo '<div style="margin: 20px 30px;">';
        echo '<h2>' . _('Open Host Problems') . '</h2>';
        echo get_inline_dashlet_html($open_host_problems, true);
        echo '</div>';
    }

    if (!empty($open_service_problems)) {
        echo '<div style="margin: 20px 30px;">';
        echo '<h2>' . _('Open Service Problems') . '</h2>';
        echo get_inline_dashlet_html($open_service_problems, true);
        echo '</div>';
    }

    ?>
        </div>
    </div>
    <script type="text/javascript">
        $(function() {
            $('#ack_filter').change(function() {

                $("#" + window['<?php echo $open_host_problems[DASHLET_PARAMS_VAR]; ?>']['acknowledgements']).val($(this).val());
                dashlet_load_url('<?php echo $open_host_problems[DASHLET_ID]; ?>');

                $("#" + window['<?php echo $open_problems_summary[DASHLET_PARAMS_VAR]; ?>']['acknowledgements']).val($(this).val());
                dashlet_load_url('<?php echo $open_problems_summary[DASHLET_ID]; ?>');

                $("#" + window['<?php echo $open_service_problems[DASHLET_PARAMS_VAR]; ?>']['acknowledgements']).val($(this).val());
                dashlet_load_url('<?php echo $open_service_problems[DASHLET_ID]; ?>');

                $.ajax({
                    type: "POST",
                    data: { "cmd" : "update", "ack_filter" : $(this).val() }
                });
            });
        });
    </script>
    <?php

}