<?php
//
// Constants Declaration File
// Copyright (c) 2016 - Nagios Enterprises, LLC. All rights reserved.
//

define('DEFAULT_LANGUAGE', 'en_US');

// LOG LEVELS
define('LOG_LEVEL_DISABLED', 1);
define('LOG_LEVEL_ERROR',    2);
define('LOG_LEVEL_WARN',     4);
define('LOG_LEVEL_INFO',     8);
define('LOG_LEVEL_DEBUG',    16);
define('LOG_LEVEL_TRACE',    48);

// LOG TYPES
define('LOG_TYPE_APPLICATION', 0);
define('LOG_TYPE_SECURITY',    1);
define('LOG_TYPE_SYSTEM',      2);
define('LOG_TYPE_AUDIT',       3);

// Adding flash message constants for easy memorization
define('FLASH_MSG_INFO', 'info');
define('FLASH_MSG_ERROR', 'error');
define('FLASH_MSG_SUCCESS', 'success');
define('FLASH_MSG_WARNING', 'warning');

// DEFAULT LOG FILES
define('DEFAULT_LOG_FILE',      '/usr/local/nagiosfusion/var/log/fusion.log');
define('DEFAULT_DEBUG_FILE',    '/usr/local/nagiosfusion/var/log/fusion.debug');
define('DEFAULT_DB_ERROR_FILE', '/usr/local/nagiosfusion/var/log/dberrors.log');

// DATABASE SETTINGS
define('DEFAULT_DATABASE_CONNECTION_TIMEOUT', 10);

// DATABASE ERRORS
define('DB_ERROR_NONE',                 0);
define('DB_ERROR_CONSTRUCT',            1);
define('DB_ERROR_CONFIG_NONE',          2);
define('DB_ERROR_CONFIG_INCOMPLETE',    3);
define('DB_ERROR_CONNECT',              4);
define('DB_ERROR_LAST_ROW_COUNT',       5);
define('DB_ERROR_LAST_INSERT_ID',       6);
define('DB_ERROR_EXEC',                 7);
define('DB_ERROR_EXEC_QUERY',           8);
define('DB_ERROR_FETCH_ROWS',           9);
define('DB_ERROR_BIND',                 10);
define('DB_ERROR_PREPARE',              11);
define('DB_ERROR_TRANS_BEGIN',          12);
define('DB_ERROR_TRANS_COMMIT',         13);
define('DB_ERROR_TRANS_ROLLBACK',       14);

// CHECK CREDENTIALS FAILED TYPES
define('CHECKCRED_FAILED_GET_USER_ID',  0);
define('CHECKCRED_FAILED_LOCKED',       1);
define('CHECKCRED_FAILED_DISABLED',     2);
define('CHECKCRED_FAILED_EXTAUTH',      3);
define('CHECKCRED_FAILED_SKIPLOCAL',    4);
define('CHECKCRED_FAILED_INVALIDPASS',  5);

// DATE FORMATS
define('DF_AUTO',    0);
define('DF_ISO8601', 1); // 2008-01-31 23:30:01
define('DF_US',      2); // 01/31/2008 23:30:01
define('DF_EURO',    3); // 31/01/2008 23:30:01

// DATE/TIME TYPES
define('DT_AUTO',            0);
define('DT_LONG_DATE_TIME',  1);
define('DT_SHORT_DATE_TIME', 2);
define('DT_SHORT_DATE',      3);
define('DT_SHORT_TIME',      4);
define('DT_HTTP_DATE_TIME',  5);
define('DT_SQL_DATE_TIME',   6);
define('DT_SQL_DATE',        7);
define('DT_SQL_TIME',        8);
define('DT_UNIX',            9);

// THEME
define('DEFAULT_THEME',  'modern');

// NUMBER FORMATS
define('NF_AUTO',   0);
define('NF_1',      1); // 1000000.00  - English w/o commas
define('NF_2',      2); // 1,000,000.00 - English
define('NF_3',      3); // 1.000.000,00  - German
define('NF_4',      4); // 1 000 000,00 - French
define('NF_5',      5); // 1'000'000,00 - Swiss

// SERVER TYPES
define('SERVER_TYPE_FUSION',  15);
define('SERVER_TYPE_XI',       1);
define('SERVER_TYPE_CORE',     2);
define('SERVER_TYPE_NNA',      4);
define('SERVER_TYPE_NLS',      8);
define('SERVER_TYPE_NEW_XI',   16);

// AUTHENTICATION TYPES
define('AUTH_TYPE_FUSEKEY', 0);
define('AUTH_TYPE_SESSION', 1);
define('AUTH_TYPE_BASIC',   2);
define('AUTH_TYPE_API',     3);

// CALLBACKS
define('CALLBACK_FOOTER_CONTENT_END',       'footer_content_end');
define('CALLBACK_FOOTER_CONTENT_START',     'footer_content_Start');
define('CALLBACK_FOOTER_END',               'footer_end');
define('CALLBACK_FOOTER_START',             'footer_start');
define('CALLBACK_HEADER_END',               'header_end');
define('CALLBACK_HEADER_START',             'header_start');
define('CALLBACK_HOME_PAGE',                'show_home_page');
define('CALLBACK_SESSION_STARTED',          'session_started');
define('CALLBACK_PROCESS_AUTH_INFO',        'auth_info');
define('CALLBACK_POLLED_PRE',               'polled_pre');
define('CALLBACK_POLLED_POST',              'polled_post');
define('CALLBACK_DBMAINT',                  'dbmaint');
define('CALLBACK_MENU_INITIALIZED',         'menu_initialized');
define('CALLBACK_FUSION_LOGO',              'fusion_logo');
define('CALLBACK_GET_DASHBOARD',            'get_dashboard');
define('CALLBACK_USER_CREATED',             'user_created');

// COMPONENTS
define('COMPONENT_NAME',                'name');
define('COMPONENT_TITLE',               'title');
define('COMPONENT_TYPE',                'type');
define('COMPONENT_ENCRYPTED',           'encrypted');
define('COMPONENT_DIRECTORY',           'directory');
define('COMPONENT_CORE',                'core');
define('COMPONENT_SERVER_TYPE',         'servertype');
define('COMPONENT_VERSION',             'version');
define('COMPONENT_AUTHOR',              'author');
define('COMPONENT_DESCRIPTION',         'description');
define('COMPONENT_DATE',                'date');
define('COMPONENT_COPYRIGHT',           'copyright');
define('COMPONENT_LICENSE',             'license');
define('COMPONENT_HOMEPAGE',            'homepage');
define('COMPONENT_CONFIG_FUNCTION',     'configfunc');
define('COMPONENT_REQUIRES_ROOT_SETUP', 'requires_root_setup');
define('COMPONENT_REQUIRES_VERSION',    'requires_version');
define('COMPONENT_REGISTERED',          'registered');
define('COMPONENT_FUNCTION',            'reg_function');
define('COMPONENT_ERROR_MESSAGE',       'error_msg');

// COMPONENT TYPES
define('COMPONENT_TYPE_USER', 'user');
define('COMPONENT_TYPE_CORE', 'core');

// COMPONENT CONFIGURE MODES
define('COMPONENT_CONFIG_MODE_GET', 'get');
define('COMPONENT_CONFIG_MODE_SET', 'set');

// DASHLETS
define('DASHLET_NAME',          'dashlet_name');
define('DASHLET_TYPE',          'type');
define('DASHLET_SERVER_TYPE',   'servertype');
define('DASHLET_DIRECTORY',     'directory');
define('DASHLET_VERSION',       'version');
define('DASHLET_AUTHOR',        'author');
define('DASHLET_DESCRIPTION',   'description');
define('DASHLET_DATE',          'date');
define('DASHLET_COPYRIGHT',     'copyright');
define('DASHLET_LICENSE',       'license');
define('DASHLET_HOMEPAGE',      'homepage');
define('DASHLET_BGCOLOR',       'bgcolor');
define('DASHLET_HEIGHT',        'height');
define('DASHLET_ID',            'dashlet_id');
define('DASHLET_LOAD_URL',      'load_url');
define('DASHLET_OPACITY',       'opacity');
define('DASHLET_PADDING',       'padding');
define('DASHLET_PARAMS',        'params');
define('DASHLET_PARAMS_VAR',    'params_var');
define('DASHLET_PINNED',        'pinned');
define('DASHLET_REFRESH',       'refresh');
define('DASHLET_SHOW_TITLE',    'show_title');
define('DASHLET_TITLE',         'title');
define('DASHLET_WIDTH',         'width');
define('DASHLET_ZINDEX',        'zindex');
define('DASHLET_PREVIEW',       'preview');
define('DATABASE_ID',           'database_id');
define('DASHLET_X',             'x');
define('DASHLET_Y',             'y');
define('DASHLET_INLINE_VAR',    'inline_var');

// DASHLET TYPES
define('DASHLET_TYPE_USER', 'user');
define('DASHLET_TYPE_CORE', 'core');
define('DASHLET_TYPE_COMPONENT', 'component');


// SUBSYS
define('SUBSYS_OK',         0);
define('SUBSYS_STOPPED',    1);
define('SUBSYS_ERROR',      2);
define('SUBSYS_UNKNOWN',    3);

// COMMAND STATUS
define('COMMAND_STATUS_QUEUED',     0);
define('COMMAND_STATUS_PROCESSING', 1);
define('COMMAND_STATUS_COMPLETED',  2);

// COMMANDS
define('COMMAND_CHANGE_TIMEZONE',               100);
define('COMMAND_DELETE_COMPONENT',              101);
define('COMMAND_INSTALL_COMPONENT',             102);
define('COMMAND_PACKAGE_COMPONENT',             103);
define('COMMAND_DELETE_DASHLET',                104);
define('COMMAND_INSTALL_DASHLET',               105);
define('COMMAND_PACKAGE_DASHLET',               106);
define('COMMAND_RESTART_HTTPD',                 107);
define('COMMAND_UPGRADE_TO_LATEST', 			108);

// COMMAND RESULT CODES
define('COMMAND_RESULT_OK',     0);
define('COMMAND_RESULT_ERROR',  1);

// POLL TYPE ENDPOINTS FOR APIS
define('POLL_TYPE_HOSTSTATUS',          'hoststatus');
define('POLL_TYPE_SERVICESTATUS',       'servicestatus');
define('POLL_TYPE_ALERTS',              'alerts');
define('POLL_TYPE_ALERT_HISTORY',       'alert_history');
define('POLL_TYPE_CLUSTER_HEALTH',      'cluster_health');
define('POLL_TYPE_CLUSTER_STATS',       'cluster_stats');
define('POLL_TYPE_INDEX_STATS',         'index_stats');
define('POLL_TYPE_SNMP_RECEIVERS',      'snmp_receivers');
define('POLL_TYPE_NRDP_SERVERS',        'nrdp_servers');
define('POLL_TYPE_INSTANCE_HEALTH',     'instance_health');
define('POLL_TYPE_NOTIFICATIONS',       'notifications');
//define('POLL_TYPE_STATEHISTORY',      'statehistory');
define('POLL_TYPE_COMMENT',             'comment');
define('POLL_TYPE_DOWNTIME',            'downtime');
define('POLL_TYPE_CONTACT',             'contact');
define('POLL_TYPE_HOST',                'host');
define('POLL_TYPE_SERVICE',             'service');
define('POLL_TYPE_HOSTGROUP',           'hostgroup');
define('POLL_TYPE_SERVICEGROUP',        'servicegroup');
define('POLL_TYPE_CONTACTGROUP',        'contactgroup');
define('POLL_TYPE_HOSTGROUPMEMBERS',    'hostgroupmembers');
define('POLL_TYPE_SERVICEGROUPMEMBERS', 'servicegroupmembers');
define('POLL_TYPE_CONTACTGROUPMEMBERS', 'contactgroupmembers');
define('POLL_TYPE_STATUS',              'status');
define('POLL_TYPE_USER',                'user');
define('POLL_TYPE_INFO',                'info');

// NNA INTEGRATION
define('POLL_TYPE_NNA_SOURCES_BANDWIDTH',   'nna_sources_bandwidth');
define('POLL_TYPE_NNA_SOURCES',             'nna_sources');
define('POLL_TYPE_NNA_CPU',                 'nna_cpu');
define('POLL_TYPE_NNA_MEMORY',              'nna_memory');
define('POLL_TYPE_NNA_ROOT_DRIVE',          'nna_root_drive');
define('POLL_TYPE_NNA_ALERTS',              'nna_alerts');

// LOGENTRY TYPES (FROM NDO/INCLUDE/NAGIOS-4X/LOGGING.H | AND NAGIOSXI/CONSTANTS.INC.PHP)
define('NSLOG_RUNTIME_ERROR',           1);
define('NSLOG_RUNTIME_WARNING',         2);
define('NSLOG_VERIFICATION_ERROR',      4);
define('NSLOG_VERIFICATION_WARNING',    8);
define('NSLOG_CONFIG_ERROR',            16);
define('NSLOG_CONFIG_WARNING',          32);
define('NSLOG_PROCESS_INFO',            64);
define('NSLOG_EVENT_HANDLER',           128);
define('NSLOG_EXTERNAL_COMMAND',        512);
define('NSLOG_HOST_UP',                 1024);
define('NSLOG_HOST_DOWN',               2048);
define('NSLOG_HOST_UNREACHABLE',        4096);
define('NSLOG_SERVICE_OK',              8192);
define('NSLOG_SERVICE_UNKNOWN',         16384);
define('NSLOG_SERVICE_WARNING',         32768);
define('NSLOG_SERVICE_CRITICAL',        65536);
define('NSLOG_PASSIVE_CHECK',           131072);
define('NSLOG_INFO_MESSAGE',            262144);
define('NSLOG_HOST_NOTIFICATION',       524288);
define('NSLOG_SERVICE_NOTIFICATION',    1048576);

// USER TYPES (FOR USERS_SERVERS TABLE)
define('USER_TYPE_MAPPED', 0);
define('USER_TYPE_LOGIN',  1);
define('USER_TYPE_EXCLUSION', 2);

// USER TYPES (FOR DB USERS,LEVEL)
define('USER_LEVEL_NONPRIV',  0);
define('USER_LEVEL_ADMIN',    1);

// NAGIOS XI STATES
define('STATE_UP',          0);
define('STATE_DOWN',        1);
define('STATE_UNREACHABLE', 2);
define('STATE_OK',          0);
define('STATE_WARNING',     1);
define('STATE_CRITICAL',    2);
define('STATE_UNKNOWN',     3);

// NAGIOS CORE STATES / (STATUSES)
define('CORE_HOST_PENDING',         1);
define('CORE_HOST_UP',              2);
define('CORE_HOST_DOWN',            4);
define('CORE_HOST_UNREACHABLE',     8);
define('CORE_SERVICE_PENDING',      1);
define('CORE_SERVICE_OK',           2);
define('CORE_SERVICE_WARNING',      4);
define('CORE_SERVICE_UNKNOWN',      8);
define('CORE_SERVICE_CRITICAL',     16);

// NAGIOS CGI JSON STATUSES (core/include/archiveutils.h)
define('AU_OBJTYPE_HOST',           (1<<0));
define('AU_OBJTYPE_SERVICE',        (1<<1));
define('AU_STATETYPE_HARD',         (1<<0));
define('AU_STATETYPE_SOFT',         (1<<1));
define('AU_STATE_HOST_UP',          (1<<0));
define('AU_STATE_HOST_DOWN',        (1<<1));
define('AU_STATE_HOST_UNREACHABLE', (1<<2));
define('AU_STATE_SERVICE_OK',       (1<<3));
define('AU_STATE_SERVICE_WARNING',  (1<<4));
define('AU_STATE_SERVICE_CRITICAL', (1<<5));
define('AU_STATE_SERVICE_UNKNOWN',  (1<<6));
define('AU_NOTIFICATION_HOST_DOWN',                 (1<<0));
define('AU_NOTIFICATION_HOST_UNREACHABLE',          (1<<1));
define('AU_NOTIFICATION_HOST_RECOVERY',             (1<<2));
define('AU_NOTIFICATION_HOST_CUSTOM',               (1<<3));
define('AU_NOTIFICATION_HOST_ACK',                  (1<<4));
define('AU_NOTIFICATION_HOST_FLAPPING_START',       (1<<5));
define('AU_NOTIFICATION_HOST_FLAPPING_STOP',        (1<<6));
define('AU_NOTIFICATION_SERVICE_CRITICAL',          (1<<7));
define('AU_NOTIFICATION_SERVICE_WARNING ',          (1<<8));
define('AU_NOTIFICATION_SERVICE_RECOVERY',          (1<<9));
define('AU_NOTIFICATION_SERVICE_CUSTOM',            (1<<10));
define('AU_NOTIFICATION_SERVICE_ACK',               (1<<11));
define('AU_NOTIFICATION_SERVICE_FLAPPING_START',    (1<<12));
define('AU_NOTIFICATION_SERVICE_FLAPPING_STOP',     (1<<13));
define('AU_NOTIFICATION_SERVICE_UNKNOWN',           (1<<14));

// DATA RETENTION POLICIES
define('DEFAULT_LOG_RETENTION',     3); // IN DAYS
define('DEFAULT_POLLED_RETENTION',  1); // IN DAYS

// GRAB DATA RELATED VALUES
define('DEFAULT_AUTH_INTERVAL',        300);
define('DEFAULT_POLLING_INTERVAL',     300);

define('DEFAULT_SIMULTANEOUS_POLLERS', 1);
define('DEFAULT_LIVE_DATA_TIMEOUT', 45);
define('DEFAULT_POLLING_LOCK_STALE_THRESHOLD', 300);
define('DEFAULT_POLL_RECORD_COUNT', 1000);

// META TYPES
define('META_TYPE_USER',    1);

// MISCELLANEOUS MAGIC NUMBERS
define('MAGIC_NUMBER_LENGTH_TO_DETERMINE_ZIP_CAME_FROM_GITLAB', 40);

// XML FILES
define('XML_COMPONENT_VERSIONS', 'https://api.nagios.com/product_versions/nagiosfusion/4/fusion_components_api_versions.xml');
define('XML_DASHLET_VERSIONS', 'https://api.nagios.com/product_versions/nagiosfusion/4/fusion_dashlets_api_versions.xml');