<?php
require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

$no_servers = grab_request_var('no_servers');
if ($no_servers) {
    echo '<h2 style="margin: 20px 20px 0; padding: 0">' . _("No servers have checked in with data yet.") . ' :(</h2><div style="max-width: 360px">';
}

$change_program_settings_class = '';
$configure_fused_servers_class = '';
$change_mail_settings_class = '';

$red_links = 'style="color: #b90000;"';
if (!get_option('changed_program_settings', false))
    $change_program_settings_class = $red_links;
if (!get_option('configured_fused_server', false))
    $configure_fused_servers_class = $red_links;
if (!get_option('changed_mail_settings', false))
    $change_mail_settings_class = $red_links;

?>
<table class="table table-condensed table-striped table-bordered" style="background-color: #FFF;">
    <tr>
        <td>
            <span class="infotable_subtitle">
                <?php echo _('Initial Setup Tasks'); ?>:
            </span>
        </td>
    </tr>
    <tr>
        <td>
            <ul>
                <li>
                    <a href="<?php echo get_base_url(); ?>admin/?fusionwindow=settings.php" target="_top" <?php echo $change_program_settings_class; ?>>
                        <strong>
                            <?php echo _('Change program settings'); ?>
                        </strong>
                    </a>
                    <br>
                    <?php echo _('Change your global system settings and defaults.'); ?>
                </li>
                <li>
                    <a href="<?php echo get_base_url(); ?>admin/?fusionwindow=servers.php" target="_top" <?php echo $configure_fused_servers_class; ?>>
                        <strong>
                            <?php echo _('Configure your Fused Servers'); ?>
                        </strong>
                    </a>
                    <br>
                    <?php echo _('Connect Fusion with your XI & Core servers to start receiving data.'); ?>
                </li>
                <li>
                    <a href="<?php echo get_base_url(); ?>admin/?fusionwindow=email.php" target="_top" <?php echo $change_mail_settings_class; ?>>
                        <strong>
                            <?php echo _('Change your mail settings'); ?>
                        </strong>
                    </a>
                    <br>
                    <?php echo _('Configure email settings for Nagios Fusion.'); ?>
                </li>
            </ul>
        </td>
    </tr>
    <tr>
        <td>
            <span class="infotable_subtitle">
                <?php echo _('Ongoing Tasks'); ?>:
            </span>
        </td>
    </tr>
    <tr>
        <td>
            <ul>
                <li>
                    <a href="<?php echo get_base_url(); ?>admin/?fusionwindow=users.php" target="_top">
                        <?php echo _('Add new user accounts'); ?>
                    </a>
                    <br>
                    <?php echo _('Setup new users with access to Nagios Fusion.'); ?>
                </li>
            </ul>
        </td>
    </tr>
</table>
<?php
if ($no_servers)
    echo '</div>';
