<?php

register_fused_server_stats_dashlet();
function register_fused_server_stats_dashlet() {

	$dashlet_opts = array(
        DASHLET_NAME 		=> 'fused_server_stats',
        DASHLET_TYPE        => DASHLET_TYPE_CORE,
        DASHLET_SERVER_TYPE => SERVER_TYPE_FUSION,
        DASHLET_VERSION		=> '1.0.0',
        DASHLET_DATE		=> '02/03/2017',
        DASHLET_AUTHOR		=> 'Nagios Enterprises',
        DASHLET_DESCRIPTION	=> _('Overview of Fused Servers'),
        DASHLET_COPYRIGHT	=> '&copy; 2017 Nagios Enterprises, LLC',
        DASHLET_HOMEPAGE	=> 'www.nagios.com',
        DASHLET_LICENSE     => _('Nagios Software License'),
        DASHLET_PREVIEW		=> get_dashlets_base_url() . 'fused_server_stats/fused_server_stats.png',
        DASHLET_LOAD_URL	=> get_dashlets_base_url() . 'fused_server_stats/fused_server_stats.php',
        DASHLET_TITLE		=> _('Fused Server Stats'),
        DASHLET_WIDTH		=> 300,
		);

    register_dashlet($dashlet_opts);
}



function fused_server_stats_get_server_data($server, &$server_name, &$server_type, &$img, &$msg, &$ok = null) {

    $server = get_server($server);
    if ($server === false)
        return false;

    $server_name = encode_html($server['name']);
    $server_type = server_type_to_readable($server['server_type']);

    $img = get_icon_url('ok_small.png');
    $msg = _('Authentication OK');
    $ok = true;

    if (check_server_authentication($server, $failure_on_stale = true) === false) {
        $img = get_icon_url('critical_small.png');
        $msg = _('Authentication Failed');
        $ok = false;
    }

    $msg .= encode_form_val(' (' . $server['last_auth_time'] . ')');
}
