<?php
require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

fused_server_stats_dashlet();

function fused_server_stats_dashlet() {

    $servers = get_servers();

    $tbody = '';

    foreach ($servers as $server) {
        $tbody .= fused_server_stats_row($server);
    }

    echo '
        <table class=" table table-condensed table-striped table-bordered table-no-pad-mar sysstat infotable">
            <thead>
                <tr>
                    <th>' . _('Server') . '</th>
                    <th>' . _('Type') . '</th>
                    <th class="status">' . _('Status') . '</th>
                </tr>
            </thead>
            <tbody>
                ' . $tbody . '
            </tbody>
        </table>';
}

function fused_server_stats_row($server) {

    if (fused_server_stats_get_server_data($server, $server_name, $server_type, $img, $msg) === false)
        return '';
 
    return '
        <tr>
            <td>' . $server_name . '</td>
            <td>' . $server_type . '</td>
            <td class="status">
                <img src="' . $img . '" title="' . $msg . '" />
            </td>
        </tr>';
}
