<?php

register_fusion_subsys_status_dashlet();

function register_fusion_subsys_status_dashlet() {

	$dashlet_opts = array(
		DASHLET_NAME 		=> 'fusion_subsys_status',
        DASHLET_TYPE        => DASHLET_TYPE_CORE,
		DASHLET_SERVER_TYPE => SERVER_TYPE_FUSION,
		DASHLET_VERSION		=> '1.0.0',
		DASHLET_DATE		=> '02/03/2017',
		DASHLET_AUTHOR		=> 'Nagios Enterprises',
		DASHLET_DESCRIPTION	=> _('Check the health of your Fusion Subystems'),
		DASHLET_COPYRIGHT	=> '&copy; 2017 Nagios Enterprises, LLC',
		DASHLET_HOMEPAGE	=> 'www.nagios.com',
		DASHLET_LICENSE     => _('Nagios Software License'),
		DASHLET_PREVIEW		=> get_dashlets_base_url() . 'fusion_subsys_status/fusion_subsys_status.png',
		DASHLET_LOAD_URL	=> get_dashlets_base_url() . 'fusion_subsys_status/fusion_subsys_status.php',
		DASHLET_TITLE		=> _('Fusion Subsystem Status'),
		DASHLET_WIDTH		=> 240,
        DASHLET_HEIGHT		=> 220,
		);

	register_dashlet($dashlet_opts);
}


function fusion_subsys_status_subsys_array() {

    return array(
        'auth_subsys',
        'cmd_subsys',
        'dbmaint_subsys',
        'log_subsys',
        'poll_subsys',
        'poll_locks'
        );
}

function fusion_subsys_status_get_sysstat_rows() {

    global $db;

    $sysstat_rows = $db->exec_query('SELECT * FROM sysstat WHERE server_id = 0');

    $subsys_array = fusion_subsys_status_subsys_array();
    $return_array = array();

    if (!is_array($sysstat_rows))
        $sysstat_rows = array();

    foreach ($sysstat_rows as $row) {
        foreach ($row as $key => $value) {
            $row[$key] = encode_html($value);
        }
        if (in_array($row['metric'], $subsys_array))
            $return_array[] = $row;                
    }

    // now check to see if there are any missing
    foreach ($subsys_array as $subsys) {

        $found = false;
        foreach ($sysstat_rows as $row) {
            if ($row['metric'] == $subsys)
                $found = true;
        }

        // inject a fake subsys result
        if (!$found) {
            $return_array[] = array(
                'value' => 'no_data',
                'metric' => $subsys,
                'update_time' => date('Y-m-d H:i:s'),
                );
        }
    }

    return $return_array;
}

function fusion_subsys_status_get_row_data($row, &$metric, &$img, &$msg, &$status = null) {

    $metric = fusion_subsys_status_metric_to_readable($row['metric']);
    $value = $row['value'];

    // keep formatted and non formatted so we can use strtotime in calculations
    $update_time = convert_timestring_to_local_users_time($row['update_time'], true);
    $time = convert_timestring_to_local_users_time($row['update_time'], false);

    // default to being ok
    $img = get_icon_url('ok_small.png');
    $msg = $metric . _(' reported OK');
    $status = $value;

    switch ($status) {
        case SUBSYS_STOPPED:
            $img = get_icon_url('critical_small.png');
            $msg = $metric . _(' reported STOPPED');
            break;
        case SUBSYS_ERROR:
            $img = get_icon_url('critical_small.png');
            $msg = $metric . _(' reported ERROR');
            break;
        case SUBSYS_UNKNOWN:
            $img = get_icon_url('warning_small.png');
            $msg = $metric . _(' reported UNKNOWN');
            break;
    }

    if ($status !== 'no_data') {

        // if it didn't run in the last 5 minutes
        // then its only a warning
        if (time() - 300 > strtotime($time)) {

            $msg = get_icon_url('warning_small.png');
            $msg = $metric . _(' last check was over 5 minutes ago');
        }

        // if it didn't run in the last 10 minutes
        // its a serious problem
        if (time() - 600 > strtotime($time)) {

            $msg = get_icon_url('critical_small.png');
            $msg = $metric . _(' last check was over 10 minutes ago');
        }
    }

    // append users formatted date to msg
    $msg .= " ({$update_time})";
}

function fusion_subsys_status_metric_to_readable($metric) {

    switch ($metric) {
        case 'auth_subsys':     return _('Authentication Subsystem');
        case 'cmd_subsys':      return _('Command Subsystem');
        case 'dbmaint_subsys':  return _('Database Maintenance');
        case 'log_subsys':      return _('Logging Subsystem');
        case 'poll_subsys':     return _('Polling Subsystem');
        case 'poll_locks':      return _('Polling Locks');
    }

    return '';
}
