<?php
require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

fusion_subsys_status_dashlet();

function fusion_subsys_status_dashlet() {

    $sysstat_rows = fusion_subsys_status_get_sysstat_rows();

    $tbody = '';

    foreach ($sysstat_rows as $row) {
        $tbody .= fusion_subsys_status_row($row);
    }

    echo '
        <table class="table table-condensed table-striped table-bordered table-no-pad-mar sysstat infotable">
            <thead>
                <tr>
                    <th class="subsystem">' . _('Subsystem') . '</th>
                    <th class="status">' . _('Status') . '</th>
                </tr>
            </thead>
            <tbody>
                ' . $tbody . '
            </tbody>
        </table>';
}

function fusion_subsys_status_row($row) {

    fusion_subsys_status_get_row_data($row, $metric, $img, $msg, $color);
 
    if ($metric == "Polling Locks") {

        $number_of_polling_locks = get_number_of_polling_locks();
        $img = get_icon_url('action_small.gif');

        return '
        <tr>
            <td>' . $metric . ": <span id=\"number_of_polling_locks\">{$number_of_polling_locks}</span>" . '</td>
            <td class="status">
                <a id="truncate_polling_locks_btn">
                    <img style="width: 18px; height: 18px;" src="' . $img . '"/>
                </a>
            </td>
        </tr>

        <script>

            $(document).ready(function(){
                $(\'[data-toggle="popover"]\').popover({html:true}); 

                $(\'#truncate_polling_locks_btn\').popover({
                    html: true,
                    placement: "right",
                    content: "<button class=\"btn btn-xs btn-default\" id=\"truncate_polling_locks\" style=\"font-size: .9em;\">Clear polling locks</button>"
                });

                // Handle some z-index fun when the polling button is pressed
                const dlet = $(\'#truncate_polling_locks_btn\').parent().parent().parent().parent().parent().parent().parent();
                $("#truncate_polling_locks_btn").on("click", function() {
                    $(dlet).css(\'z-index\', \'auto\');
                })

                // Need to assign a delegated event to the status div because the entire status table is loaded via a .html call
                $(".status").on("click", "#truncate_polling_locks", function() {
                    $.ajax({
                        type: \'POST\',
                        url: ajax_helper_url,
                        data: { cmd: \'truncate_polling_locks\', nsp: nsp_str },
                        success: function() {
                            $("#number_of_polling_locks").html(0);
                            $(".popover").remove();
                            flash_message("Successfully deleted polling locks.", "success", true);
                        },
                        error: function() {
                            flash_message("Failed to delete polling locks.", "error", true);
                        }
                    });
                });

                // Close the popover when clicking anywhere outside
                $(document).on(\'click\', function (e) {
                    // Check if the click is outside the popover and the button
                    if (!$(e.target).closest(\'#truncate_polling_locks_btn\').length && !$(e.target).closest(\'.popover\').length) {
                        $(\'.popover\').popover(\'hide\');
                    }
                });
            });

        </script>';
    }

    return '
        <tr>
            <td>' . $metric . '</td>
            <td class="status">
                <img src="' . $img . '" title="' . $msg . '" />
            </td>
        </tr>';
}

function get_number_of_polling_locks() {

    global $db;

    $number_of_polling_locks = 0;

    $db->query('SELECT COUNT(*) FROM polling_lock');
    $db->exec();
    $rows = $db->fetch_rows();

    $number_of_polling_locks = $rows[0]['COUNT(*)'];

    return $number_of_polling_locks;

}
?>
