<?php
require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

fusion_sysstat_dashlet();

function fusion_sysstat_dashlet() {

    global $db;

    $sysstat_rows = $db->exec_query('SELECT * FROM sysstat WHERE server_id = 0');

    $sysstat = array();

    foreach ($sysstat_rows as $row) {

        $metric = $row['metric'];

        if (!in_array($metric, fusion_sysstat_array()))
            continue;

        $value = fusion_sysstat_value_to_array($row['value']);

        $safe_value = array();
        foreach ($value as $key => $value) {
            $new_key = encode_html($key);
            $safe_value[$new_key] = encode_html($value);
        }

        $sysstat[$metric] = $safe_value;
    }

    // need this for load calculations
    $processor_count = intval(exec("cat /proc/cpuinfo | grep processor | wc -l"));
    if ($processor_count <= 0)
        $processor_count = 1;

    ?>
    <table class="table table-condensed table-striped table-bordered table-no-pad-mar sysstat serverstat">
        <thead>
            <tr>
                <th><?php echo _('Metric'); ?></th>
                <th><?php echo _('Value'); ?></th>
                <th class="visualize"></th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <th colspan="3"><?php echo _('Load'); ?></th>
            </tr>
            <tr>
                <td><?php echo _('1 min'); ?></td>
                <td><?php $load1 = fusion_sysstat_print_value($sysstat, 'load', 'load1') ?></td>
                <td><?php fusion_sysstat_print_bar($load1, $processor_count, $processor_count, $processor_count * 2); ?></td>
            </tr>
            <tr>
                <td><?php echo _('5 min'); ?></td>
                <td><?php $load5 = fusion_sysstat_print_value($sysstat, 'load', 'load5') ?></td>
                <td><?php fusion_sysstat_print_bar($load5, $processor_count, $processor_count, $processor_count * 2); ?></td>
            </tr>
            <tr>
                <td><?php echo _('15 min'); ?></td>
                <td><?php $load15 = fusion_sysstat_print_value($sysstat, 'load', 'load15') ?></td>
                <td><?php fusion_sysstat_print_bar($load15, $processor_count, $processor_count, $processor_count * 2); ?></td>
            </tr>



            <tr>
                <th colspan="3"><?php echo _('CPU Stats'); ?></th>
            </tr>
            <tr>
                <td><?php echo _('User'); ?></td>
                <td><?php $user = fusion_sysstat_print_value($sysstat, 'cpustat', 'user', ' %') ?></td>
                <td><?php fusion_sysstat_print_bar($user, 0, 200, 200); ?></td>
            </tr>
            <tr>
                <td><?php echo _('Nice'); ?></td>
                <td><?php $nice = fusion_sysstat_print_value($sysstat, 'cpustat', 'nice', ' %') ?></td>
                <td><?php fusion_sysstat_print_bar($nice, 0, 200, 200); ?></td>
            </tr>
            <tr>
                <td><?php echo _('System'); ?></td>
                <td><?php $system = fusion_sysstat_print_value($sysstat, 'cpustat', 'system', ' %') ?></td>
                <td><?php fusion_sysstat_print_bar($system, 0, 200, 200); ?></td>
            </tr>
            <tr>
                <td><?php echo _('I/O Wait'); ?></td>
                <td><?php $iowait = fusion_sysstat_print_value($sysstat, 'cpustat', 'iowait', ' %') ?></td>
                <td><?php fusion_sysstat_print_bar($iowait, 0, 10, 20); ?></td>
            </tr>
            <tr>
                <td><?php echo _('Steal'); ?></td>
                <td><?php $steal = fusion_sysstat_print_value($sysstat, 'cpustat', 'steal', ' %') ?></td>
                <td><?php fusion_sysstat_print_bar($steal, 0, 200, 200); ?></td>
            </tr>
            <tr>
                <td><?php echo _('Idle'); ?></td>
                <td><?php $idle = fusion_sysstat_print_value($sysstat, 'cpustat', 'idle', ' %') ?></td>
                <td><?php fusion_sysstat_print_bar($idle, 0, 200, 200); ?></td>
            </tr>



            <tr>
                <th colspan="3"><?php echo _('Memory'); ?></th>
            </tr>
            <tr>
                <td><?php echo _('Total'); ?></td>
                <td><?php $total = fusion_sysstat_print_value($sysstat, 'memory', 'total', ' MB') ?></td>
                <td></td>
            </tr>
            <tr>
                <td><?php echo _('Used'); ?></td>
                <td><?php $used = fusion_sysstat_print_value($sysstat, 'memory', 'used', ' MB') ?></td>
                <td><?php fusion_sysstat_print_bar($used, $total, $total * 2, $total * 2); ?></td>
            </tr>
            <tr>
                <td><?php echo _('Free'); ?></td>
                <td><?php $free = fusion_sysstat_print_value($sysstat, 'memory', 'free', ' MB') ?></td>
                <td><?php fusion_sysstat_print_bar($free, $total, $total * 2, $total * 2); ?></td>
            </tr>
            <tr>
                <td><?php echo _('Shared'); ?></td>
                <td><?php $shared = fusion_sysstat_print_value($sysstat, 'memory', 'shared', ' MB') ?></td>
                <td><?php fusion_sysstat_print_bar($shared, $total, $total * 2, $total * 2); ?></td>
            </tr>
            <tr>
                <td><?php echo _('Buffers'); ?></td>
                <td><?php $buffers = fusion_sysstat_print_value($sysstat, 'memory', 'buffers', ' MB') ?></td>
                <td><?php fusion_sysstat_print_bar($buffers, $total, $total * 2, $total * 2); ?></td>
            </tr>
            <tr>
                <td><?php echo _('Cached'); ?></td>
                <td><?php $cached = fusion_sysstat_print_value($sysstat, 'memory', 'cached', ' MB') ?></td>
                <td><?php fusion_sysstat_print_bar($cached, $total, $total * 2, $total * 2); ?></td>
            </tr>



            <tr>
                <th colspan="3"><?php echo _('Swap'); ?></th>
            </tr>
            <tr>
                <td><?php echo _('Total'); ?></td>
                <td><?php $total = fusion_sysstat_print_value($sysstat, 'swap', 'total', ' MB') ?></td>
                <td></td>
            </tr>
            <tr>
                <td><?php echo _('Used'); ?></td>
                <td><?php $used = fusion_sysstat_print_value($sysstat, 'swap', 'used', ' MB') ?></td>
                <td><?php fusion_sysstat_print_bar($used, $total, $total * 0.33, $total * 0.5); ?></td>
            </tr>
            <tr>
                <td><?php echo _('Free'); ?></td>
                <td><?php $free = fusion_sysstat_print_value($sysstat, 'swap', 'free', ' MB') ?></td>
                <td><?php fusion_sysstat_print_bar($free, $total, $total * 2, $total * 2); ?></td>
            </tr>
        </tbody>
    </table>
    <?php
}

function fusion_sysstat_print_value($arr, $subsys, $var, $suffix = '') {

    $number = 0;

    if (isset($arr["sysstat_{$subsys}"][$var])) {
        $number = $arr["sysstat_{$subsys}"][$var];
        echo get_formatted_number($number, 2) . $suffix;
    }
    else
        echo _('N/A');

    return $number;
}

function fusion_sysstat_print_bar($val, $max, $warn, $crit) {

    $val = (float) $val;
    $max = (float) $max;

    if ($val > $max && $max > 0)
        $val = $max;

    $width = $val;
    if ($max > 0)
        $width = ($val / $max) * 100;

    $color_ok = "#5CDF45";
    $color_warn = "#FEFF6F";
    $color_crit = "#FF795F";

    $color = "background-color: {$color_ok};";
    if ($val >= $warn)
        $color = "background-color: {$color_warn};";
    if ($val >= $crit)
        $color = "background-color: {$color_crit};";

    echo '<div style="height: 100%; width: ' . $width . '%;' . $color . '">&nbsp;</div>';
}


function fusion_sysstat_array() {

    return array(
        'sysstat_cpustat',
        'sysstat_load',
        'sysstat_memory',
        'sysstat_swap',
        );
}

function fusion_sysstat_value_to_array($value) {

    return unserialize(base64_decode($value));
}
