<?php
require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

fusion_update_dashlet();

function fusion_update_dashlet()
{
    $last_update_check = get_option('last_update_check_time', 0);
    $last_update_check_succeeded = get_option("last_update_check_succeeded", 0);

    $update_available = get_option("update_available", "");
    $update_version = get_option("update_version", "");
    $update_release_date = get_option("update_release_date", "");
    $update_release_notes = get_option("update_release_notes", "");

    $status = '<span><img src="'.get_icon_url("unknown_small.png").'"></span> '._("Update Check Problem: Last update check failed.");
    if ($last_update_check_succeeded) {
        if ($update_available) {
            $status = '<span><img src="'.get_icon_url("critical_small.png").'"></span> '._("A new Nagios Fusion update is available.");
        } else {
            $status = '<span><img src="'.get_icon_url("ok_small.png").'"></span> '._("Your Nagios Fusion installation is up to date.");
        }
    }
?>

    <div class="dashlet-infotable">
        <p><b><?php echo $status; ?></b></p>
        <?php if ($update_available) { ?>
        <p><?php echo $update_release_notes; ?></p>
        <p><?php echo _("Visit"); ?> <a href='https://www.nagios.com/products/nagios-fusion/' target='_blank'>www.nagios.com</a> <?php echo _("to obtain the latest update"); ?></p>
        <?php } ?>
        <table>
            <tr><td style="width: 160px;"><?php echo _('Latest Available Version'); ?>:</td><td><?php echo $update_version; ?></td></tr>
            <tr><td><?php echo _('Installed Version'); ?>:</td><td><?php echo get_product_version(); ?></td></tr>
            <tr><td><?php echo _('Last Update Check'); ?>:</td><td><?php echo user_date($last_update_check); ?></td></tr>
        </table>
    </div>

<?php
}
