<?php

register_host_status_dashlet();

function register_host_status_dashlet() {

    $dashlet_opts = array(
        DASHLET_NAME        => 'host_status',
        DASHLET_TYPE        => DASHLET_TYPE_CORE,
        DASHLET_SERVER_TYPE => SERVER_TYPE_XI | SERVER_TYPE_CORE,
        DASHLET_VERSION     => '1.0.0',
        DASHLET_DATE        => '02/08/2017',
        DASHLET_AUTHOR      => 'Nagios Enterprises',
        DASHLET_DESCRIPTION => _('View the status of a single host'),
        DASHLET_COPYRIGHT   => '&copy; 2017 Nagios Enterprises, LLC',
        DASHLET_HOMEPAGE    => 'www.nagios.com',
        DASHLET_LICENSE     => _('Nagios Software License'),
        DASHLET_PREVIEW     => get_dashlets_base_url() . 'host_status/host_status.png',
        DASHLET_LOAD_URL    => get_dashlets_base_url() . 'host_status/host_status.php',
        DASHLET_TITLE       => _('Host Status'),
        DASHLET_WIDTH       => 800,
        DASHLET_PARAMS      => 'host_status_dashlet_params',
        );

    register_dashlet($dashlet_opts);
}

function host_status_dashlet_params() {

    // build dependent fields from cached data
    $servers = array();
    $hosts = array();

    // if we don't have any data yet, this stops every page load trying to build the arrays
    if (dashlets_data_check($redirect = false)) {

        foreach (get_servers() as $server) {
            if ($server['server_type'] == SERVER_TYPE_XI || $server['server_type'] == SERVER_TYPE_CORE) {

                $servers[$server['server_id']] = $server['name'];
                
                $dashlets_params_simple_hosts = get_server_polled_key($server, 'dashlets_params_simple_hosts', $limit = 1);
                if (!isset($dashlets_params_simple_hosts[0]))
                    continue;

                $hosts[$server['server_id']] = unpack_array($dashlets_params_simple_hosts[0]['dashlets_params_simple_hosts']);
            }
        }
    }

    asort($servers);
    asort($hosts);

    return array(
        'server' => array(
            'name'      => _('Server'),
            'options'   => $servers,
            ), 

        'host' => array(
            'name'      => _('Host'),
            'options'   => $hosts,
            'dependent' => 'server',
            ),

        );
}