<?php
require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

dashlets_data_check();

host_status_dashlet();

function host_status_dashlet() {

    $server = grab_request_var('server');
    $host = grab_request_var('host', 0);

    $server = get_server($server);
    if ($server === false) {
        echo '<h3>' . _('Invalid server selection!') . '</h3>';
        exit();
    }

    $host_status = get_server_polled_key($server, 'host_status', $limit = 1);
    if (!isset($host_status[0]['host_status'])) {
        echo '<h3>' . _('No recent data found for specified server!') . '</h3>';
        exit();
    }

    $polled_time = date('Y-m-d H:i:s', $host_status[0]['polled_time']);
    $polled_time = convert_server_timestring_to_local_timestring($server, $polled_time);

    $hosts = unpack_array($host_status[0]['host_status']);

    if (!isset($hosts[$host])) {
        echo '<h3>' . _('No matching data found for host and service specified!') . '</h3>';
        exit();
    }

    $output = '';
    if (!empty($hosts[$host]['output']))
        $output = $hosts[$host]['output'];

    $host_state = STATE_UP;
    if (isset($hosts[$host]['current_state']))
        $host_state = $hosts[$host]['current_state'];

    $host = get_tactical_link($host, $server, 
        "includes/components/xicore/status.php?show=hostdetail&host=" . urlencode($host),
        "extinfo.cgi?type=1&host=" . urlencode($host));

    $host_class = '';
    switch ($host_state) {
        case STATE_UP:          $host_class = 'havehostup'; break;
        case STATE_DOWN:        $host_class = 'havehostdown'; break;
        case STATE_UNREACHABLE: $host_class = 'havehostunreachable'; break;
    }

    if (!empty($host_class))
        $host_class = " class=\"{$host_class}\"";

    ?>
    <table class="table table-condensed table-striped table-bordered host_status_summary_dashlet tactical">
        <tr>
            <td>
                <?php echo _('Host'); ?>:
            </td>
            <td<?php echo $host_class; ?>>
                <?php echo $host; ?>
            </td>
            <td>
                <?php echo $polled_time; ?>
            </td>
            <td>
                <?php echo $output; ?>
            </td>
        </tr>
    </table>
    <?php
}
