<?php
require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

register_hostgroup_summary_dashlet();

function register_hostgroup_summary_dashlet() {

    $dashlet_opts = array(
        DASHLET_NAME        => 'hostgroup_summary',
        DASHLET_TYPE        => DASHLET_TYPE_CORE,
        DASHLET_SERVER_TYPE => SERVER_TYPE_XI | SERVER_TYPE_CORE,
        DASHLET_VERSION     => '1.0.0',
        DASHLET_DATE        => '02/09/2017',
        DASHLET_AUTHOR      => 'Nagios Enterprises',
        DASHLET_DESCRIPTION => _('Quick overview into the health of a hostgroup'),
        DASHLET_COPYRIGHT   => '&copy; 2017 Nagios Enterprises, LLC',
        DASHLET_HOMEPAGE    => 'www.nagios.com',
        DASHLET_LICENSE     => _('Nagios Software License'),
        DASHLET_PREVIEW     => get_dashlets_base_url() . 'hostgroup_summary/hostgroup_summary.png',
        DASHLET_LOAD_URL    => get_dashlets_base_url() . 'hostgroup_summary/hostgroup_summary.php',
        DASHLET_TITLE       => _('Hostgroup Summary'),
        DASHLET_WIDTH       => 800,
        DASHLET_PARAMS      => 'hostgroup_summary_dashlet_params',
        );

    register_dashlet($dashlet_opts);
}

function hostgroup_summary_dashlet_params() {
    
    // build dependent fields from cached data
    $servers = array();
    $hostgroups = array();

    if (dashlets_data_check($redirect = false)) {

        foreach (get_servers() as $server) {
            if ($server['server_type'] == SERVER_TYPE_XI || $server['server_type'] == SERVER_TYPE_CORE) {

                $servers[$server['server_id']] = $server['name'];
                
                $dashlets_params_simple_hostgroups = get_server_polled_key($server, 'dashlets_params_simple_hostgroups', $limit = 1);
                if (!isset($dashlets_params_simple_hostgroups[0]))
                    continue;

                $hostgroups[$server['server_id']] = unpack_array($dashlets_params_simple_hostgroups[0]['dashlets_params_simple_hostgroups']);
            }
        }
    }

    asort($servers);
    asort($hostgroups);

    return array(
        'server' => array(
            'name'      => _('Server'),
            'options'   => $servers,
            ), 

        'hostgroup' => array(
            'name'      => _('Hostgroup'),
            'options'   => $hostgroups,
            'dependent' => 'server',
            ),

        );
}