<?php
require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

dashlets_data_check();

hostgroup_summary_dashlet();

function hostgroup_summary_dashlet() {

    $server = grab_request_var('server');
    $hostgroup = grab_request_var('hostgroup', 0);

    $server = get_server($server);
    if ($server === false) {
        echo '<h3>' . _('Invalid server selection!') . '</h3>';
        exit();
    }

    $hostgroup_members = get_server_polled_key($server, 'hostgroup_members', $limit = 1);
    $host_status = get_server_polled_key($server, 'host_status', $limit = 1);
    $service_status = get_server_polled_key($server, 'service_status', $limit = 1);

    if (!isset($hostgroup_members[0]['hostgroup_members'])) {
        echo '<h3>' . _('No recent data found for specified server!') . '</h3>';
        exit();
    }

    $polled_time = date('Y-m-d H:i:s', $hostgroup_members[0]['polled_time']);
    $polled_time = convert_server_timestring_to_local_timestring($server, $polled_time);

    $hostgroup_members = unpack_array($hostgroup_members[0]['hostgroup_members']);
    $host_status = unpack_array($host_status[0]['host_status']);
    $service_status = unpack_array($service_status[0]['service_status']);

    if (!isset($hostgroup_members[$hostgroup])) {
        echo '<h3>' . _('No hostgroup data found!') . '</h3>';
        exit();
    }

    $host_counts = array(
        STATE_UP => 0, 
        STATE_DOWN => 0,
        STATE_UNREACHABLE => 0
        );
    $service_counts = array(
        STATE_OK => 0,
        STATE_WARNING => 0,
        STATE_CRITICAL => 0,
        STATE_UNKNOWN => 0,
        );

    $members = $hostgroup_members[$hostgroup]['members'];
    if (is_array($members) && count($members) > 0) {
        foreach ($members as $host_name) {

            if (isset($host_status[$host_name])) {

                $host = $host_status[$host_name];
                $host_counts[$host['current_state']]++;

                if (isset($service_status[$host_name])) {
                    foreach ($service_status[$host_name] as $service) {

                        $service_counts[$service['current_state']]++;
                    }
                }
            }
        }
    }

    $host_output = '';
    $service_output = '';

    if (array_sum($host_counts) == 0) {
        $host_output = '0 ' . _('hosts');
    } else {
        foreach ($host_counts as $state => $value) {
            $value = intval($value);

            $class = $verb = '';
            $link_xi = $link_core = '';

            $noun = _('hosts');
            if ($value == 1)
                $noun = _('host');

            switch ($state) {
                case STATE_UP:
                    $class = 'hostup';
                    $verb = _('up');
                    $link_xi = 'includes/components/xicore/status.php?show=hosts&hostgroup=' . urlencode($hostgroup) . '&hoststatustypes=2';
                    $link_core = 'status.cgi?hostgroup=' . urlencode($hostgroup) . '&style=hostdetail&&hoststatustypes=2&hostprops=0';
                    break;

                case STATE_DOWN:
                    $class = 'hostdown';
                    $verb = _('down');
                    $link_xi = 'includes/components/xicore/status.php?show=hosts&hostgroup=' . urlencode($hostgroup) . '&hoststatustypes=4';
                    $link_core = 'status.cgi?hostgroup=' . urlencode($hostgroup) . '&style=hostdetail&hoststatustypes=4&hostprops=0';
                    break;

                case STATE_UNREACHABLE:
                    $class = 'hostunreachable';
                    $verb = _('unreachable');
                    $link_xi = 'includes/components/xicore/status.php?show=hosts&hostgroup=' . urlencode($hostgroup) . '&hoststatustypes=8';
                    $link_core = 'status.cgi?hostgroup=' . urlencode($hostgroup) . '&style=hostdetail&hoststatustypes=8&hostprops=0';
                    break;
            }
            if ($value > 0) {
                $host_value = "{$value} {$noun} {$verb}";
                $host_link = get_tactical_link($host_value, $server, $link_xi, $link_core);
                $host_output .= "<div class=\"{$class}\">{$host_link}</div>";
            }
        }
    }

    if (array_sum($service_counts) == 0) {
        $service_output = '0 ' . _('services');
    } else {
        foreach ($service_counts as $state => $value) {
            $value = intval($value);

            $class = $verb = '';
            $link_xi = $link_core = '';
            $noun = _('services');

            if ($value == 1)
                $noun = _('service');

            switch ($state) {
                case STATE_OK:
                    $class = 'serviceok';
                    $verb = _('ok');
                    $link_xi = 'includes/components/xicore/status.php?show=services&hostgroup=' . urlencode($hostgroup) . '&servicestatustypes=2';
                    $link_core = 'status.cgi?hostgroup=' . urlencode($hostgroup) . '&style=detail&&servicestatustypes=2&hoststatustypes=15&serviceprops=0&hostprops=0';
                    break;

                case STATE_WARNING:
                    $class = 'servicewarning';
                    $verb = _('warning');
                    $link_xi = 'includes/components/xicore/status.php?show=services&hostgroup=' . urlencode($hostgroup) . '&servicestatustypes=4';
                    $link_core = 'status.cgi?hostgroup=' . urlencode($hostgroup) . '&style=detail&servicestatustypes=4&hoststatustypes=15&serviceprops=0&hostprops=0';
                    break;

                case STATE_CRITICAL:
                    $class = 'servicecritical';
                    $verb = _('critical');
                    $link_xi = 'includes/components/xicore/status.php?show=services&hostgroup=' . urlencode($hostgroup) . '&servicestatustypes=16';
                    $link_core = 'status.cgi?hostgroup=' . urlencode($hostgroup) . '&style=detail&servicestatustypes=16&hoststatustypes=15&serviceprops=0&hostprops=0';
                    break;

                case STATE_UNKNOWN:
                    $class = 'serviceunknown';
                    $verb = _('unknown');
                    $link_xi = 'includes/components/xicore/status.php?show=services&hostgroup=' . urlencode($hostgroup) . '&servicestatustypes=8';
                    $link_core = 'status.cgi?hostgroup=' . urlencode($hostgroup) . '&style=detail&servicestatustypes=8&hoststatustypes=15&serviceprops=0&hostprops=0';
                    break;
            }
            if ($value > 0) {
                $service_value = "{$value} {$noun} {$verb}";
                $service_link = get_tactical_link($service_value, $server, $link_xi, $link_core);
                $service_output .= "<div class=\"{$class}\">{$service_link}</div>";
            }
        }
    }

    $hostgroup = get_tactical_link($hostgroup, $server, 
        'includes/components/xicore/status.php?show=services&hostgroup=' . urlencode($hostgroup),
        'status.cgi?hostgroup=' . urlencode($hostgroup) . '&style=overview');
    ?>
    <table class="table table-condensed table-striped table-bordered hoststatustable servicestatustable tactical">
        <tr>
            <th>
                <?php echo _('Hostgroup'); ?>
            </th>
            <th>
                <?php echo _('Hosts'); ?>
            </th>
            <th>
                <?php echo _('Services'); ?>
            </th>
        </tr>
        <tr>
            <td>
                <?php echo $hostgroup; ?>
            </td>
            <td>
                <?php echo $host_output; ?>
            </td>
            <td>
                <?php echo $service_output; ?>
            </td>
        </tr>
    </table>
    <?php
}
