<?php

require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

dashlets_data_check();
nls_alert_history_dashlet();

print_dashlet_pager('page', 2, 100, 10);

global $page;

function get_alert_history() {
    get_dashlet_dependent_request_vars($server, $host, $service);
    
    global $page;
    global $num_records_per_page;

    $page = 1;
    $num_records_per_page = 10;
    if (isset($_REQUEST['page']))
        $page = $_REQUEST['page'];

    if (isset($_REQUEST['num_records_per_page']))
        $num_records_per_page = $_REQUEST['num_records_per_page'];

    // Get alerts defined in NLS from polled_extras
    $alert_data = get_server_polled_key($server, 'alert_history', $limit = 1, $user_id = 0);
    if (!isset($alert_data[0]['alert_history']))
        return false;

    // Get users defined in NLS from polled_extra
    $nls_user_data = get_server_polled_key($server, 'nls_users', $limit = 1, $user_id = 0);
    if (!isset($nls_user_data[0]['nls_users']))
        return false;

    // History of sent alerts
    $alert_history = unpack_array($alert_data[0]['alert_history']);
    // Nagios Log Server user information (id => username)
    $users = unpack_array($nls_user_data[0]['nls_users']);

    return $alert_history;

}

function nls_alert_history_dashlet() {

    global $page;
    global $num_records_per_page;
    global $total_pages;

    $alert_history = get_alert_history();

    // As of php 8 count() throws an error instead of a warning on invalid countable types
    // Needed to handle an empty array as it returns as a false boolean
    // -acoil 2023-17-01
    if ($alert_history) {
        $total_pages = count($alert_history) / $num_records_per_page;
    }
    else {
        $total_pages = 0;
    }
    // Store table pages as a multidimensional array
    $pages = array();

    // Build pages
    $element_counter = 0; // Counter to keep track of place in $alert_history
    for ($page_number = 1; $page_number <= $total_pages; $page_number++) {

        for ($current_element = 0; $current_element < $num_records_per_page; $current_element++) {
            $pages[$page_number][$current_element] = $alert_history[$element_counter];
            $element_counter++;
        }
    }

    if (empty($pages)) {
            echo _("There is no data to display. Please ensure your Log Server instance is running, and the specified credentials are accurate.");
            exit(0);
    }   
?>
    <table class="table table-condensed table-striped table-bordered host_status_summary_dashlet tactical">
        <tr>
            <th><?php echo _('Alert Name') ?></th>
            <th><?php echo _('Run Time') ?></th>
            <th><?php echo _('Status') ?></th>
            <th><?php echo _('Alert Output') ?></th>
            <th><?php echo _('Interval') ?></th>
            <th><?php echo _('Lookback') ?></th>
            <th><?php echo _('Warning') ?></th>
            <th><?php echo _('Critical') ?></th>
        </tr>

        <?php 
        if (empty($pages)) {
            echo "There is no data to display. Please ensure your Log Server instance is running, and the specified credentials are accurate.";
        }
        foreach($pages[$page] as $index => $alert):?>
            <tr>
                <td><?php echo $alert['alert_name']; ?></td>
                <td>
                    <?php echo date('r', $alert['ran']); ?>
                </td>

                <!-- Get proper background color based on last status -->
                <?php switch ($alert['status']) {
                    case '0':
                        $background = "#B2FF5F";
                        $status_string = "OK";
                        break;
                    case '1':
                        $background = "#FEFF5F";
                        $status_string = "WARNING";
                        break;
                    case '2':
                        $background = "#FF795F";
                        $status_string = "CRITICAL";
                        break;
                }?>

                <td style="background-color: <?php echo $background ?>;" ><?php echo $status_string; ?></td>
                <td><?php echo encode_html($alert['output']); ?></td>
                <td><?php echo encode_html($alert['check_interval']); ?></td>
                <td><?php echo encode_html($alert['lookback_period']); ?></td>
                <td><?php echo encode_html($alert['warning_threshold']); ?></td>
                <td><?php echo encode_html($alert['critical_threshold']); ?></td>
            </tr>
        <?php endforeach; ?>
    </table>

<?php } 

?>
