<?php

require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

dashlets_data_check();
nls_alerts_dashlet();

function nls_alerts_dashlet() {

	get_dashlet_dependent_request_vars($server, $host, $service);

    // Get alerts defined in NLS from polled_extras
    $alert_data = get_server_polled_key($server, 'alerts', $limit = 1, $user_id = 0);
    if (!isset($alert_data[0]['alerts'])) {
        echo _("There is no data to display. Please ensure your Log Server instance is running, the specified credentials are accurate, and you have alerts defined.");
        return false;
    }
    $alerts = unpack_array($alert_data[0]['alerts']);

    // Get users defined in NLS from polled_extra
    $nls_user_data = get_server_polled_key($server, 'nls_users', $limit = 1, $user_id = 0);
    if (!isset($nls_user_data[0]['nls_users'])) {
        echo _("Unable to retrieve user data. Please ensure your Log Server instance is running, the specified credentials are accurate, and you have alerts defined.");
        return false;
    }
    $users = unpack_array($nls_user_data[0]['nls_users']);

    // Get SNMP receivers defined in NLS from polled_extras
    $nls_snmp_receivers = get_server_polled_key($server, 'nls_snmp_receivers', $limit = 1, $user_id = 0);
    if (!isset($nls_snmp_receivers[0]['nls_snmp_receivers'])) {
        $snmp_receivers = array();
    }
    else {
        $snmp_receivers = unpack_array($nls_snmp_receivers[0]['nls_snmp_receivers']);
    }

    $nls_nrdp_servers = get_server_polled_key($server, 'nls_nrdp_servers', $limit = 1, $user_id = 0);
    if (!isset($nls_nrdp_servers[0]['nls_nrdp_servers'])) {
        $nrdp_servers = array();
    }
    else {
        $nrdp_servers = unpack_array($nls_nrdp_servers[0]['nls_nrdp_servers']);
    }

?>
    <table class="table table-condensed table-striped table-bordered host_status_summary_dashlet tactical" style="width: auto;">
        <th><?php echo _('Name') ?></th>
        <th><?php echo _('Created By') ?></th>
        <th><?php echo _('Last Run') ?></th>
        <th><?php echo _('Check Interval') ?></th>
        <th><?php echo _('Status') ?></th>
        <th><?php echo _('Last Output') ?></th>
        <th><?php echo _('Alert Method') ?></th>
        <?php foreach($alerts as $alert => $data): ?>
        <tr>
            <td><?php echo encode_html($data['name']); ?></td>
            <td><?php echo encode_html($data['created_by']); ?></td>
            <td>
                <?php $epoch_time = $data['last_run'];
                      $date = new DateTime("@$epoch_time");
                      echo encode_html($date->format('m-d-Y H:i:s')); ?>
            </td>
            <td><?php echo encode_html($data['check_interval']) ?></td>

            <!-- Get proper background color based on last status -->
            <?php switch ($data['last_status']) {
                case 'ok':
                    $background = "#B2FF5F";
                    break;
                case 'warning':
                    $background = "#FEFF5F";
                    break;
                case 'critical':
                    $background = "#FF795F";
                    break;
            }?>

            <td style="background-color: <?php echo $background ?>;" ><?php echo encode_html(strtoupper($data['last_status'])); ?></td>
            <td><?php echo encode_html($data['last_output']); ?></td>

            <!-- Create useful Alert Method string -->
            <?php

            $alert_method_string = '';

            switch ($data['alert_method']['type']) {
                case 'email':
                    // Create recipient list as array
                    $recipients = array();

                    foreach ($data['alert_method']['user_ids'] as $id => $user) {
                        $recipients[] = $users[$user]; 
                    }

                    $alert_method_string .= 'Email to <strong>' . encode_html(implode(", ", $recipients)) . '</strong>';
                    break;
                case 'exec':
                    $script = encode_html(end(explode("/", $data['alert_method']['path'])));
                    $alert_method_string .= 'Executing script <strong>' . $script . "</strong>";
                    break;
                case 'snmp':
                    $receiver_id = $data['alert_method']['snmp_receiver'];
                    $alert_method_string = 'SNMP Trap to <strong>' . encode_html($snmp_receivers[$receiver_id]['name']) . ' (' . encode_html($snmp_receivers[$receiver_id]['address']) . ':' . encode_html($snmp_receivers[$receiver_id]['port']) . ')</strong> using SNMP ' . encode_html($snmp_receivers[$receiver_id]['version']);
                    break;
                case 'nrdp':
                    $nrdp_server_id = $data['alert_method']['server_id'];
                    $alert_method_string = 'NRDP on <strong>' . encode_html($nrdp_servers[$nrdp_server_id]['name']) . '</strong> (As ' .  encode_html($data['alert_method']['hostname']) . " - " . encode_html($data['alert_method']['servicename']) . ')';
                    break;
                default:
                    $alert_method_string .= "None";
                    break;

            }

            ?>

            <td><?php echo _($alert_method_string); ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
<?php } ?>
