<?php

require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

dashlets_data_check();
nls_alerts_dashlet();

function nls_alerts_dashlet() {

	get_dashlet_dependent_request_vars($server, $host, $service);

    global $page;
    $page = 0;
    if (isset($_REQUEST['page']))
        $page = $_REQUEST['page'];

    // Get NLS cluster health data
    $cluster_health_data = get_server_polled_key($server, 'cluster_health', $limit = 1, $user_id = 0);
    if (!isset($cluster_health_data[0]['cluster_health'])) {
        echo _("There is no data to display. Please ensure your Log Server instance is running, and the specified credentials are accurate.");
        return false;
    }

    // Defined alerts
    $cluster_health = unpack_array($cluster_health_data[0]['cluster_health']);
    $cluster_health = $cluster_health[0];

?>
<script>

function update_page($elem, page) {
        var $dashlet = $elem.parents('.dashlet');
        var dashlet_database_id = $dashlet.data('database-id');
        var data = { 
                id: dashlet_database_id, 
                params: {
                        page: page
                }
            };
        console.log(data);
        console.log('before..');
        dashlet_load_url($dashlet, { page: page }, true);
        console.log('after..');
        update_dashlet(data);
}

</script>

<table class="table table-condensed table-striped table-bordered host_status_summary_dashlet tactical nls_cluster_health" style="width: auto;">
        <tr>
            <td><?php echo _('Cluster ID'); ?></td>
            <td><?php echo encode_html(_($cluster_health['cluster_name'])); ?></td>
        </tr>
        <tr>

            <!-- Get proper background color based on last status -->
            <?php switch ($cluster_health['cluster_status']) {
                case 'green':
                    $background = "#B2FF5F";
                    break;
                case 'yellow':
                    $background = "#FEFF5F";
                    break;
                case 'red':
                    $background = "#FF795F";
                    break;
            }?>

            <td><?php echo _('Cluster Status'); ?></td>
            <td style="background-color: <?php echo $background ?>;" ><?php echo encode_html(_(ucfirst($cluster_health['cluster_status']))); ?></td>

        </tr>
        <tr>
            <?php 

            if ($cluster_health['timed_out'] === false) {
                $timed_out = "False";
            } else {
                $timed_out = "True";
            }
            ?>

            <td><?php echo _('Timed Out'); ?></td>
            <td><?php echo encode_html(_($timed_out)); ?></td>
        </tr>
        <tr>
            <td><?php echo _('# Instances'); ?></td>
            <td><?php echo encode_html(_($cluster_health['number_of_nodes'])); ?></td>
        </tr>
        <tr>
            <td><?php echo _('# Data Instances'); ?></td>
            <td><?php echo encode_html(_($cluster_health['number_of_data_nodes'])); ?></td>
        </tr>
        <tr>
            <td><?php echo _('Active Primary Shards'); ?></td>
            <td><?php echo encode_html(_($cluster_health['active_primary_shards'])); ?></td>
        </tr>
        <tr>
            <td><?php echo _('Relocating Shards'); ?></td>
            <td><?php echo encode_html(_($cluster_health['relocating_shards'])); ?></td>
        </tr>
        <tr>
            <td><?php echo _('Initializing Shards'); ?></td>
            <td><?php echo encode_html(_($cluster_health['initializing_shards'])); ?></td>
        </tr>
        <tr>
            <td><?php echo _('Unassigned Shards'); ?></td>
            <td><?php echo encode_html(_($cluster_health['unassigned_shards'])); ?></td>
        </tr>
        <tr>
            <td><?php echo _('Delayed Unassigned Shards'); ?></td>
            <td><?php echo encode_html(_($cluster_health['delayed_unassigned_shards'])); ?></td>
        </tr>
        <tr>
            <td><?php echo _('# Pending Tasks'); ?></td>
            <td><?php echo encode_html(_($cluster_health['number_of_pending_tasks'])); ?></td>
        </tr>
        <tr>
            <td><?php echo _('# In Flight Fetch'); ?></td>
            <td><?php echo encode_html(_($cluster_health['number_of_in_flight_fetch'])); ?></td>
        </tr>
    </table>


<?php } ?>
