<?php

require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

dashlets_data_check();
nls_alerts_dashlet();

function nls_alerts_dashlet() {

	get_dashlet_dependent_request_vars($server, $host, $service);

    // Get NLS cluster health data
    $cluster_stats_data = get_server_polled_key($server, 'cluster_stats', $limit = 1, $user_id = 0);
    if (!isset($cluster_stats_data[0]['cluster_stats'])) {
        echo _("There is no data to display. Please ensure your Log Server instance is running, and the specified credentials are accurate.");
        return false;
    }

    // Defined alerts
    $cluster_stats = unpack_array($cluster_stats_data[0]['cluster_stats']);
    $cluster_stats = $cluster_stats[0];

?>

<table class="table table-condensed table-striped table-bordered host_status_summary_dashlet tactical" style="width: auto;">
    <tr>
        <td><?php echo _('Cluster Name'); ?></td>
        <td><?php echo encode_html(_($cluster_stats['cluster_name'])); ?></td>
    </tr>
    <tr>

        <!-- Get proper background color based on last status -->
        <?php switch ($cluster_stats['status']) {
            case 'green':
                $background = "#B2FF5F";
                break;
            case 'yellow':
                $background = "#FEFF5F";
                break;
            case 'red':
                $background = "#FF795F";
                break;
        }?> 

        <td><?php echo _('Cluster Status'); ?></td>
        <td style="background-color: <?php echo $background ?>;" ><?php echo encode_html(_(ucfirst($cluster_stats['status']))); ?></td>
    </tr>
    <tr>
        <td><?php echo _('Indices'); ?></td>
        <td><?php echo encode_html(_($cluster_stats['indices'])); ?></td>
    </tr>
    <tr>
        <td><?php echo _('Document Count'); ?></td>
        <td><?php echo encode_html(_(number_format($cluster_stats['document_count']))); ?></td>
    </tr>
    <tr>
        <td><?php echo _('Store Size'); ?></td>
        <td><?php echo encode_html(_(humanize_filesize($cluster_stats['store_size']))); ?></td>
    </tr>
    <tr>
        <td><?php echo _('Total Node Count'); ?></td>
        <td><?php echo encode_html(_($cluster_stats['total_node_count'])); ?></td>
    </tr>
    <tr>
        <td><?php echo _('# Client Nodes'); ?></td>
        <td><?php echo encode_html(_($cluster_stats['client_node_count'])); ?></td>
    </tr>
    <tr>
        <td><?php echo _('# Master Nodes'); ?></td>
        <td><?php echo encode_html(_($cluster_stats['master_node_count'])); ?></td>
    </tr>
    <tr>
        <td><?php echo _('# Data Nodes'); ?></td>
        <td><?php echo encode_html(_($cluster_stats['data_node_count'])); ?></td>
    </tr>
    <tr>
        <td><?php echo _('# Master/Data Nodes'); ?></td>
        <td><?php echo encode_html(_($cluster_stats['master_data_node_count'])); ?></td>
    </tr>
    <tr>
        <td><?php echo _('# Available Processors'); ?></td>
        <td><?php echo encode_html(_($cluster_stats['number_of_available_processors'])); ?></td>
    </tr>
    <tr>
        <td><?php echo _('Total Memory'); ?></td>
        <td><?php echo encode_html(_(humanize_filesize($cluster_stats['total_memory']))); ?></td>
    </tr>
    <tr>
        <td><?php echo _('Process CPU'); ?></td>
        <td><?php echo encode_html(_($cluster_stats['process_cpu'] . "%")); ?></td>
    </tr>
    <tr>
        <td><?php echo _('Total Storage'); ?></td>
        <td><?php echo encode_html(_(humanize_filesize($cluster_stats['mem_total_storage_in_bytes']))); ?></td>
    </tr>
    <tr>
        <td><?php echo _('Free Storage'); ?></td>
        <td><?php echo encode_html(_(humanize_filesize($cluster_stats['mem_free_storage_in_bytes']))); ?></td>
    </tr>
    <tr>
        <td><?php echo _('Available Storage'); ?></td>
        <td><?php echo encode_html(_(humanize_filesize($cluster_stats['mem_available_in_bytes']))); ?></td>
    </tr>
    <tr>
        <td><?php echo _('Disk IOPS'); ?></td>
        <td><?php echo encode_html(_(number_format($cluster_stats['disk_iops']))); ?></td>
    </tr>
    <tr>
        <td><?php echo _('Data Read'); ?></td>
        <td><?php echo encode_html(_(humanize_filesize($cluster_stats['data_read']))); ?></td>
    </tr>
    <tr>
        <td><?php echo _('Data Written'); ?></td>
        <td><?php echo encode_html(_(humanize_filesize($cluster_stats['data_written']))); ?></td>
    </tr>
    <tr>
        <td><?php echo _('I/O Size'); ?></td>
        <td><?php echo encode_html(_(humanize_filesize($cluster_stats['io_size']))); ?></td>
    </tr>
    <tr>
        <td><?php echo _('JVM Heap Used'); ?></td>
        <td><?php echo encode_html(_(humanize_filesize($cluster_stats['jvm_heap_used_in_bytes']))); ?></td>
    </tr>
    <tr>
        <td><?php echo _('JVM Heap Max'); ?></td>
        <td><?php echo encode_html(_(humanize_filesize($cluster_stats['jvm_heap_max_in_bytes']))); ?></td>
    </tr>
</table>

<?php } ?>
