<?php

require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

dashlets_data_check();
nls_alerts_dashlet();

function nls_alerts_dashlet() {

	get_dashlet_dependent_request_vars($server, $host, $service);

    // Get NLS cluster health data
    $index_data = get_server_polled_key($server, 'indices', $limit = 1, $user_id = 0);
    if (!isset($index_data[0]['indices'])) {
        echo _("There is no data to display. Please ensure your Log Server instance is running, and the specified credentials are accurate.");
        return false;
    }

    // Defined alerts
    $indices = unpack_array($index_data[0]['indices']);
    // Sort so newest entries are first
    krsort($indices);

?>

<table id="index_stats_table" class="table table-condensed table-striped table-bordered host_status_summary_dashlet tactical" style="width: auto;">
    <tr>
        <th><?php echo _('Index'); ?></th>
        <th><?php echo _('# Docs'); ?></th>
        <th><?php echo _('Primary Size'); ?></th>
    </tr>
    <?php foreach($indices as $index => $data):?>
        <tr>
            <td><?php echo encode_html(_($index)); ?></td>
            <td><?php echo encode_html(number_format($data['document_count'])); ?></td>
            <td><?php echo encode_html(humanize_filesize($data['primary_size'])); ?></td>
        </tr>
    <?php endforeach; ?>
</table>

<!-- Apply Overflow auto to this dashlet -->
<script type="text/javascript">
    $('#index_stats_table').parent().css('overflow', 'auto');
</script>

<?php } ?>
