<?php

require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

dashlets_data_check();
nna_alerts_dashlet();

function nna_alerts_dashlet() {
    global $page;
    $page = 0;
    if (isset($_REQUEST['page']))
        $page = $_REQUEST['page'];
    
    $recent_alerts = array();
    $servers = get_servers();
    
    foreach ($servers as $server) {
        if ($server['server_type'] != SERVER_TYPE_NNA){
            continue; // We only care about fused NNA servers
        }
        
        // Get NNA system stat data
        $nna_alert_list = get_server_polled_key($server, 'nna_alerts', $limit = 1);
        
        if (empty($nna_alert_list)) {
            echo _("There is no data to display. Please ensure your Network Analyzer instance is running, and the specified credentials are accurate.");
            return false;
        }
        
        // Defined alerts
        $nna_alert_list = unpack_array($nna_alert_list[0]['nna_alerts']);

        if(is_array($nna_alert_list)) {
            if (count($nna_alert_list) > 0) {
                foreach ($nna_alert_list as $alerts) {                    
                    $alert['server_id'] = $server['server_id'];
                    $alert['server_name'] = $server['name'];
                    
                    $alert['name'] = $alerts['name'];
                    $alert['lastrun'] = $alerts['lastrun'];
                    $alert['lastcode'] = $alerts['lastcode'];
                    $alert['laststdout'] = $alerts['laststdout'];

                    $recent_alerts[] = $alert;
                }
            }
        }
    }
?>

<table class="table table-condensed table-striped table-bordered table-no-pad-mar">
    <tbody>
        <!-- Alert Titles -->
        <tr>
            <th class="nna_title"><?php echo _('Server') ?></th>
            <th class="nna_title"><?php echo _('Name') ?></th>
            <th class="nna_title"><?php echo _('Last Run') ?></th>
            <th class="nna_title"><?php echo _('Status') ?></th>
            <th class="nna_title"><?php echo _('Message') ?></th>
        </tr>
        <!-- Alert Data -->
        <tr class='alerts'>
            <?php
                foreach( $recent_alerts as $alert) {
                    $alert_code = $alert['lastcode'];
                    $alert_status = '';
                    $background = '';
                    
                    switch($alert_code) {
                        case 0:
                            $alert_status = 'OK';
                            $background = "#B2FF5F";
                            break;
                        case 1:
                            $alert_status = 'WARNING';
                            $background = "#FEFF5F";
                            break;
                        case 2:
                            $alert_status = 'CRITICAL';
                            $background = "#FF795F";
                            break;
                        case 3:
                        default:
                            $alert_status = 'UNKNOWN';
                            $background = "#FFC45F";
                            break;
                    }

                    echo 
                        "<tr>" .
                            "<td>" . encode_html($alert['server_name']) . "</td>" .
                            "<td>" . encode_html($alert['name']) . "</td>" .
                            "<td>" . $alert['lastrun'] . "</td>" .
                            "<td class='nna_alert_status' style='background-color:" . $background . "'>" . $alert_status . "</td>" .
                            "<td>" . $alert['laststdout'] . "</td>" . 
                        "</tr>";
                }
            ?>
        </tr>
    </tbody>
</table>

<?php } ?>