<?php

register_nna_bandwidth_dashlet();

function register_nna_bandwidth_dashlet() {

	$dashlet_opts = array(
        	DASHLET_NAME        => 'nna_bandwidth',
                DASHLET_TYPE        => DASHLET_TYPE_CORE,
                DASHLET_SERVER_TYPE => SERVER_TYPE_NNA,
                DASHLET_VERSION     => '1.0.0',
                DASHLET_DATE        => '11/29/2023',
                DASHLET_AUTHOR      => 'Nagios Enterprises',
                DASHLET_DESCRIPTION => _('Show the bandwidth graph of a specified source from a fused Nagios Network Analyzer server.'),
                DASHLET_COPYRIGHT   => '© 2023 Nagios Enterprises, LLC',
                DASHLET_HOMEPAGE    => 'www.nagios.com',
                DASHLET_LICENSE     => _('GPL v2'),
                DASHLET_PREVIEW     => get_dashlets_base_url() . 'nna_bandwidth/nna_bandwidth.png',
                DASHLET_LOAD_URL    => get_dashlets_base_url() . 'nna_bandwidth/nna_bandwidth.php',
                DASHLET_TITLE       => _('Network Analyzer Bandwidth'),
                DASHLET_PARAMS      => 'get_nna_bandwidth_dashlet_params',
                DASHLET_WIDTH       => 500,
                DASHLET_HEIGHT      => 350
	);

	register_dashlet($dashlet_opts);
}


function get_nna_bandwidth_dashlet_params() {
        // $arr = get_dashlet_dependent_params(true, false, false, true, SERVER_TYPE_NNA);
        // return $arr;
        
        // build dependent fields from cached data
        $servers = array();
        $server_opts = array();
        $sources = array();

        // if we don't have any data yet, this stops every page load trying to build the arrays
        if (dashlets_data_check($redirect = false)) {

                foreach (get_servers() as $server) {
                        if ($server['server_type'] != SERVER_TYPE_NNA) {
                                continue;
                        }
                        $server_opts[$server['server_id']] = $server['name'];
                        
                        $dashlets_params_masked_sources = get_server_polled_key($server, 'dashlets_params_masked_sources', $limit = 1);
                        if (!isset($dashlets_params_masked_sources[0]))
                                continue;
                        $sources[$server['server_id']] = unpack_array($dashlets_params_masked_sources[0]['dashlets_params_masked_sources']);
                }

        }
        
        // sort the options given so long as they have values
        if (is_array($server_opts)) {
                asort($server_opts);
        }
        if (is_array($sources)) {
                asort($sources);
        }

        return array(
                'server' => array(
                        'name'      => _('Server'),
                        'options'   => $server_opts,
                ), 

                'source' => array(
                        'name'      => _('Source'),
                        'options'   => $sources,
                        'dependent' => 'server',
                ),
                
                'timeperiod' => array(
                        'name'      => _('Time Period'),
                        'options'   => array(24 => '24hr', 12 => '12hr', 6 => '6hr', 4 => '4hr', 2 => '2hr'),
                ),
                
                'scale' => array(
                        'name'      => _('Scale'),
                        'options'   => array('logarithmic' => 'Logarithmic', 'linear' => 'Linear'),
                ),

        );
}


?>