<?php

require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

dashlets_data_check();
nna_system_stats_dashlet();

function nna_system_stats_dashlet() {

	get_dashlet_dependent_request_vars($server, $host, $service);

    global $page;
    $page = 0;
    if (isset($_REQUEST['page']))
        $page = $_REQUEST['page'];
    
    $nna_server_stat_data = [];
    
    // Get NNA system stat data
    $cpu_stats_data = get_server_polled_key($server, 'nna_cpu', $limit = 1, $user_id = 0);
    $memory_stats_data = get_server_polled_key($server, 'nna_memory', $limit = 1, $user_id = 0);
    $root_drive_stats_data = get_server_polled_key($server, 'nna_root_drive', $limit = 1, $user_id = 0);
    if (!isset($cpu_stats_data[0]['nna_cpu']) && !isset($memory_stats_data[0]['nna_cpu']) && !isset($root_drive_stats_data[0]['nna_cpu'])) {
        echo _("There is no data to display. Please ensure your Network Analyzer instance is running, and the specified credentials are accurate.");
        return false;
    }

    // Defined alerts
    $cpu_stats = unpack_array($cpu_stats_data[0]['nna_cpu']);
    $cpu_stats = $cpu_stats[0];
    
    $memory_stats = unpack_array($memory_stats_data[0]['nna_memory']);
    $memory_stats = $memory_stats[0];

    $root_drive_stats = unpack_array($root_drive_stats_data[0]['nna_root_drive']);
    $root_drive_stats = $root_drive_stats[0];
?>

<table class="table table-condensed table-striped table-bordered table-no-pad-mar nnastat">
    <tbody>

        <!-- CPU STATS -->
        <tr>
            <th class="nna_title" colspan="2"><?php echo _('CPU') ?></th>
        </tr>
        <tr>
            <th><?php echo _('Usage'); ?></th>
            <td><?php echo $cpu_stats['cpu_usage'] . "%"; ?></td>
        </tr>
        
        <!-- MEMORY STATS -->
        <tr>
            <th class="nna_title" colspan="2"><?php echo _('Memory') ?></th>
        </tr>
        <tr>
            <th><?php echo _('Usage'); ?></th>
            <td><?php echo round($memory_stats['used_percent'], 2) . "%"; ?></td>
        </tr>
        <tr>
            <th><?php echo _('Swap'); ?></th>
            <td><?php echo round($memory_stats['swap_percent'], 2) . "%"; ?></td>
        </tr>
        
        <!-- ROOT DRIVE STATS -->
        <tr>
            <th class="nna_title" colspan="2"><?php echo _('Root Drive') ?></th>
        </tr>
        <tr>
            <th><?php echo _('Filesystem'); ?></th>
            <td><?php echo encode_html($root_drive_stats['filesystem']); ?></td>
        </tr>
        <tr>
            <th><?php echo _('Size'); ?></th>
            <td><?php echo humanize_filesize($root_drive_stats['size']); ?></td>
        </tr>
        <tr>
            <th><?php echo _('Used'); ?></th>
            <td><?php echo humanize_filesize($root_drive_stats['used']); ?></td>
        </tr>
        <tr>
            <th><?php echo _('Available'); ?></th>
            <td><?php echo humanize_filesize($root_drive_stats['available']); ?></td>
        </tr>
        <tr>
            <th><?php echo _('Percent'); ?></th>
            <td><?php echo round($root_drive_stats['percent'], 2) . "%"; ?></td>
        </tr>
    </tbody>
</table>

<?php } ?>
