<?php

register_perfgraph_dashlet();

function register_perfgraph_dashlet() {

    $dashlet_opts = array(

        DASHLET_NAME        => 'perfgraph',
        DASHLET_TYPE        => DASHLET_TYPE_CORE,
        DASHLET_SERVER_TYPE => SERVER_TYPE_XI,
        DASHLET_VERSION     => '1.1.0',
        DASHLET_DATE        => '07/31/2018',
        DASHLET_AUTHOR      => 'Nagios Enterprises',
        DASHLET_DESCRIPTION => _('Performance Graphs'),
        DASHLET_COPYRIGHT   => '&copy; 2017-2018 Nagios Enterprises, LLC',
        DASHLET_HOMEPAGE    => 'www.nagios.com',
        DASHLET_LICENSE     => _('Nagios Software License'),

        DASHLET_PREVIEW     => get_dashlets_base_url() . 'perfgraph/perfgraph.png',
        DASHLET_LOAD_URL    => get_dashlets_base_url() . 'perfgraph/perfgraph.php',

        DASHLET_TITLE       => _('Performance Graphs'),
        DASHLET_BGCOLOR     => 'ffffff',
        DASHLET_PADDING     => '10',
        DASHLET_WIDTH       => '600',
        DASHLET_HEIGHT      => '200',
        DASHLET_REFRESH     => '60', // seconds
        DASHLET_OPACITY     => '1.00',

        DASHLET_PARAMS      => 'perfgraph_dashlet_params', 
        );

    register_dashlet($dashlet_opts);
}

function perfgraph_dashlet_params() {
    
    // build dependent fields from cached data
    $servers = array();
    $hosts = array();
    $services = array();

    // if we don't have any data yet, this stops every page load trying to build the arrays
    if (dashlets_data_check($redirect = false)) {

        foreach (get_servers() as $server) {
            if ($server['server_type'] == SERVER_TYPE_XI) {

                $servers[$server['server_id']] = $server['name'];
                
                $dashlets_params_masked_hosts = get_server_polled_key($server, 'dashlets_params_masked_hosts', $limit = 1);
                $dashlets_params_masked_services = get_server_polled_key($server, 'dashlets_params_masked_services', $limit = 1);
                if (!isset($dashlets_params_masked_hosts[0]) || !isset($dashlets_params_masked_services[0]))
                    continue;

                $hosts[$server['server_id']] = unpack_array($dashlets_params_masked_hosts[0]['dashlets_params_masked_hosts']);
                $services = array_merge($services, unpack_array($dashlets_params_masked_services[0]['dashlets_params_masked_services']));
            }
        }
    }

    // make sure the _host_ is in there!
    foreach ($services as $i => $v) {
        $services[$i]['_HOST_'] = '_HOST_';
    }

    asort($servers);
    asort($hosts);
    asort($services);

    return array(
        'server' => array(
            'name'      => _('Server'),
            'options'   => $servers,
            ), 

        'host' => array(
            'name'      => _('Host'),
            'options'   => $hosts,
            'dependent' => 'server',
            ),

        'service' => array(
            'name'      => _('Service'),
            'options'   => $services,
            'dependent' => 'host',
            ),

        );
}
