<?php

register_recent_alerts_dashlet();

function register_recent_alerts_dashlet() {

	$dashlet_opts = array(
		DASHLET_NAME 		=> 'recent_alerts',
		DASHLET_TYPE 		=> DASHLET_TYPE_CORE,
		DASHLET_SERVER_TYPE => SERVER_TYPE_XI | SERVER_TYPE_CORE,
		DASHLET_VERSION		=> '1.0.0',
		DASHLET_DATE		=> '01/24/2017',
		DASHLET_AUTHOR		=> 'Nagios Enterprises',
		DASHLET_DESCRIPTION	=> _('Recent Alerts'),
		DASHLET_COPYRIGHT	=> '&copy; 2017 Nagios Enterprises, LLC',
		DASHLET_HOMEPAGE	=> 'www.nagios.com',
		DASHLET_LICENSE     => _('Nagios Software License'),
		DASHLET_PREVIEW		=> get_dashlets_base_url() . 'recent_alerts/recent_alerts.png',
		DASHLET_LOAD_URL	=> get_dashlets_base_url() . 'recent_alerts/recent_alerts.php',
		DASHLET_TITLE		=> _('Recent Alerts'),
		DASHLET_PARAMS      => 'recent_alert_dashlet_params',
		DASHLET_HEIGHT      => 550,
		DASHLET_WIDTH       => 900,
    	);

	register_dashlet($dashlet_opts);
}


function recent_alert_dashlet_params() {

    // build dependent fields from cached data
    $servers = array();
    $hosts = array();
	$services = array();

    // if we don't have any data yet, this stops every page load trying to build the arrays
    if (dashlets_data_check($redirect = false)) {

        foreach (get_servers() as $server) {
            if ($server['server_type'] == SERVER_TYPE_XI || $server['server_type'] == SERVER_TYPE_CORE) {
                $servers[$server['server_id']] = $server['name'];
 
				$dashlets_params_masked_hosts = get_server_polled_key($server, 'dashlets_params_masked_hosts', $limit = 1);
				if (!isset($dashlets_params_masked_hosts[0]))
					continue;
				$hosts[$server['server_id']] = unpack_array($dashlets_params_masked_hosts[0]['dashlets_params_masked_hosts']);

				$dashlets_params_masked_services = get_server_polled_key($server, 'dashlets_params_masked_services', $limit = 1);
				if (!isset($dashlets_params_masked_services[0]))
					continue;
				$services = array_merge($services, unpack_array($dashlets_params_masked_services[0]['dashlets_params_masked_services']));
            }
        }
    }

    asort($servers);
    asort($hosts);
	asort($services);

	$servers = array(0 => "All Servers")+$servers;

	foreach ($hosts as $server_id => $hosts_array) {
		$hosts[$server_id] = array(0 => 'Any')+$hosts_array;
	}
	foreach ($services as $server_id => $services_array) {
		$services[$server_id] = array(0 => 'Any')+$services_array;
	}

	return array(
		'alerts_per_page' => array(
			'name'      => _('Alerts Per Page'),
			'options'   => array(10 => 10, 25 => 25, 50 => 50, 100 => 100),
		),	
		
		'server' => array(
			'name'      => _('Server'),
			'options'   => $servers,
		), 
		
		'host' => array(
			'name'      => _('Host'),
			'options'   => $hosts,
			'dependent' => 'server',
		),

		'service' => array(
			'name'      => _('Service'),
			'options'   => $services,
			'dependent' => 'host',
		),

		'state' => array(
			'name'      => _('State'),
			'options'   => array(
				0 => "Any",
				'UP' => 'UP', 
				'DOWN' => 'DOWN', 
				'UNREACHABLE'  => 'UNREACHABLE', 
				'OK'  => 'OK', 
				'WARNING'  => 'WARNING',
				'CRITICAL'  => 'CRITICAL',
				'UNKNOWN'  => 'UNKNOWN'
			),
		),

		'state_type' => array(
			'name'      => _('State Type'),
			'options'   => array(0 => "Any", 'HARD' => 'HARD', 'SOFT' => 'SOFT'),
		),
	);
}