<?php
require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

dashlets_data_check();

service_status_dashlet();

function service_status_dashlet() {

    get_dashlet_dependent_request_vars($server, $host, $service);

    $server = get_server($server);
    if ($server === false) {
        echo '<h3>' . _('Invalid server selection!') . '</h3>';
        exit();
    }

    $service_status = get_server_polled_key($server, 'service_status', $limit = 1);
    $host_status = get_server_polled_key($server, 'host_status', $limit = 1);
    if (!isset($service_status[0]['service_status'])) {
        echo '<h3>' . _('No recent data found for specified server!') . '</h3>';
        exit();
    }

    $polled_time = date('Y-m-d H:i:s', $service_status[0]['polled_time']);
    $polled_time = convert_server_timestring_to_local_timestring($server, $polled_time);

    $services = unpack_array($service_status[0]['service_status']);
    $hosts = unpack_array($host_status[0]['host_status']);
    
    if (!isset($services[$host][$service])) {
        echo '<h3>' . _('No matching data found for host and service specified!') . '</h3>';
        exit();
    }

    $output = '';
    if (!empty($services[$host][$service]['output']))
        $output = $services[$host][$service]['output'];

    $host_state = STATE_UP;
    $service_state = STATE_OK;

    if (isset($hosts[$host]) && isset($hosts[$host]['current_state']))
        $host_state = $hosts[$host]['current_state'];

    if (isset($services[$host][$service]['current_state']))
        $service_state = $services[$host][$service]['current_state'];

    $host_link = get_tactical_link($host, $server, 
        'includes/components/xicore/status.php?show=hostdetail&host=' . urlencode($host),
        'extinfo.cgi?type=1&host=' . urlencode($host));

    $service_link = get_tactical_link($service, $server,
        'includes/components/xicore/status.php?show=servicedetail&host=' . urlencode($host) . '&service=' . $service,
        'extinfo.cgi?type=2&host=' . urlencode($host) . '&service=' . urlencode($service));


    $host_class = '';
    switch ($host_state) {
        case STATE_UP:          $host_class = 'havehostup'; break;
        case STATE_DOWN:        $host_class = 'havehostdown'; break;
        case STATE_UNREACHABLE: $host_class = 'havehostunreachable'; break;
    }

    $service_class = '';
    switch ($service_state) {
        case STATE_OK:          $service_class = 'haveserviceok'; break;
        case STATE_WARNING:     $service_class = 'haveservicewarning'; break;
        case STATE_CRITICAL:    $service_class = 'haveservicecritical'; break;
        case STATE_UNKNOWN:     $service_class = 'haveserviceunknown'; break;
    }

    if (!empty($host_class))
        $host_class = " class=\"{$host_class}\"";

    if (!empty($service_class))
        $service_class = " class=\"{$service_class}\"";

    ?>
    <table class="table table-condensed table-striped table-bordered host_status_summary_dashlet service_status_summary_dashlet tactical">
        <tr>
            <td>
                <?php echo _('Host'); ?>:
            </td>
            <td<?php echo $host_class; ?>>
                <?php echo $host_link; ?>
            </td>
            <td>
                <?php echo _('Service'); ?>:
            </td>
            <td<?php echo $service_class; ?>>
                <?php echo $service_link; ?>
            </td>
            <td>
                <?php echo $polled_time; ?>
            </td>
            <td>
                <?php echo $output; ?>
            </td>
        </tr>
    </table>
    <?php
}
