<?php
require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

register_servicegroup_summary_dashlet();

function register_servicegroup_summary_dashlet() {

    $dashlet_opts = array(
        DASHLET_NAME        => 'servicegroup_summary',
        DASHLET_TYPE        => DASHLET_TYPE_CORE,
        DASHLET_SERVER_TYPE => SERVER_TYPE_XI | SERVER_TYPE_CORE,
        DASHLET_VERSION     => '1.0.0',
        DASHLET_DATE        => '02/09/2017',
        DASHLET_AUTHOR      => 'Nagios Enterprises',
        DASHLET_DESCRIPTION => _('Quick overview into the health of a servicegroup'),
        DASHLET_COPYRIGHT   => '&copy; 2017 Nagios Enterprises, LLC',
        DASHLET_HOMEPAGE    => 'www.nagios.com',
        DASHLET_LICENSE     => _('Nagios Software License'),
        DASHLET_PREVIEW     => get_dashlets_base_url() . 'servicegroup_summary/servicegroup_summary.png',
        DASHLET_LOAD_URL    => get_dashlets_base_url() . 'servicegroup_summary/servicegroup_summary.php',
        DASHLET_TITLE       => _('Servicegroup Summary'),
        DASHLET_WIDTH       => 800,
        DASHLET_PARAMS      => 'servicegroup_summary_dashlet_params', 
        );

    register_dashlet($dashlet_opts);
}

function servicegroup_summary_dashlet_params() {
    
    // build dependent fields from cached data
    $servers = array();
    $servicegroups = array();

    if (dashlets_data_check($redirect = false)) {

        foreach (get_servers() as $server) {
            if ($server['server_type'] == SERVER_TYPE_XI || $server['server_type'] == SERVER_TYPE_CORE) {

                $servers[$server['server_id']] = $server['name'];
                
                $dashlets_params_simple_servicegroups = get_server_polled_key($server, 'dashlets_params_simple_servicegroups', $limit = 1);
                if (!isset($dashlets_params_simple_servicegroups[0]))
                    continue;

                $servicegroups[$server['server_id']] = unpack_array($dashlets_params_simple_servicegroups[0]['dashlets_params_simple_servicegroups']);
            }
        }
    }

    asort($servers);
    asort($servicegroups);

    return array(
        'server' => array(
            'name'      => _('Server'),
            'options'   => $servers,
            ), 

        'servicegroup' => array(
            'name'      => _('Servicegroup'),
            'options'   => $servicegroups,
            'dependent' => 'server',
            ),

        );
}