<?php
require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

dashlets_data_check();

servicegroup_summary_dashlet();

function servicegroup_summary_dashlet() {

    $server = grab_request_var('server');
    $servicegroup = grab_request_var('servicegroup', 0);

    $server = get_server($server);
    if ($server === false) {
        echo '<h3>' . _('Invalid server selection!') . '</h3>';
        exit();
    }

    $servicegroup_members = get_server_polled_key($server, 'servicegroup_members', $limit = 1);
    $service_status = get_server_polled_key($server, 'service_status', $limit = 1);

    if (!isset($servicegroup_members[0]['servicegroup_members'])) {
        echo '<h3>' . _('No recent data found for specified server!') . '</h3>';
        exit();
    }

    $polled_time = date('Y-m-d H:i:s', $servicegroup_members[0]['polled_time']);
    $polled_time = convert_server_timestring_to_local_timestring($server, $polled_time);

    $servicegroup_members = unpack_array($servicegroup_members[0]['servicegroup_members']);
    $service_status = unpack_array($service_status[0]['service_status']);

    if (!isset($servicegroup_members[$servicegroup])) {
        echo '<h3>' . _('No servicegroup data found!') . '</h3>';
        exit();
    }

    $service_counts = array(
        STATE_OK => 0,
        STATE_WARNING => 0,
        STATE_CRITICAL => 0,
        STATE_UNKNOWN => 0,
        );

    $members = $servicegroup_members[$servicegroup]['members'];
    if (is_array($members) && count($members) > 0) {
        foreach ($members as $service) {

            if (isset($service['host_name']) && isset($service['service_description'])) {

                $host_name = $service['host_name'];
                $service_description = $service['service_description'];

                if (isset($service_status[$host_name][$service_description]['current_state'])) {
                    $current_state = $service_status[$host_name][$service_description]['current_state'];
                    $service_counts[$current_state]++;
                }
            }
        }
    }

    $service_output = '';

    if (array_sum($service_counts) == 0) {
        $service_output = '0 ' . _('services');
    } else {
        foreach ($service_counts as $state => $value) {
            $value = intval($value);

            $class = $verb = '';
            $link_xi = $link_core = '';
            $noun = _('services');

            if ($value == 1)
                $noun = _('service');

            switch ($state) {
                case STATE_OK:
                    $class = 'serviceok';
                    $verb = _('ok');
                    $link_xi = 'includes/components/xicore/status.php?show=services&servicegroup=' . urlencode($servicegroup) . '&servicestatustypes=2';
                    $link_core = 'status.cgi?servicegroup=' . urlencode($servicegroup) . '&style=detail&servicestatustypes=2&hoststatustypes=15&serviceprops=0&hostprops=0';
                    break;

                case STATE_WARNING:
                    $class = 'servicewarning';
                    $verb = _('warning');
                    $link_xi = 'includes/components/xicore/status.php?show=services&servicegroup=' . urlencode($servicegroup) . '&servicestatustypes=4';
                    $link_core = 'status.cgi?servicegroup=' . urlencode($servicegroup) . '&style=detail&servicestatustypes=4&hoststatustypes=15&serviceprops=0&hostprops=0';
                    break;

                case STATE_CRITICAL:
                    $class = 'servicecritical';
                    $verb = _('critical');
                    $link_xi = 'includes/components/xicore/status.php?show=services&servicegroup=' . urlencode($servicegroup) . '&servicestatustypes=16';
                    $link_core = 'status.cgi?servicegroup=' . urlencode($servicegroup) . '&style=detail&servicestatustypes=16&hoststatustypes=15&serviceprops=0&hostprops=0';
                    break;

                case STATE_UNKNOWN:
                    $class = 'serviceunknown';
                    $verb = _('unknown');
                    $link_xi = 'includes/components/xicore/status.php?show=services&servicegroup=' . urlencode($servicegroup) . '&servicestatustypes=8';
                    $link_core = 'status.cgi?servicegroup=' . urlencode($servicegroup) . '&style=detail&servicestatustypes=8&hoststatustypes=15&serviceprops=0&hostprops=0';
                    break;
            }
            if ($value > 0) {
                $service_value = "{$value} {$noun} {$verb}";
                $service_link = get_tactical_link($service_value, $server, $link_xi, $link_core);
                $service_output .= "<div class=\"{$class}\">{$service_link}</div>";
            }
        }
    }

    $servicegroup = get_tactical_link($servicegroup, $server, 
        'includes/components/xicore/status.php?show=services&servicegroup=' . urlencode($servicegroup),
        'status.cgi?servicegroup=' . urlencode($servicegroup) . '&style=detail');


    ?>
    <table class="table table-condensed table-striped table-bordered hoststatustable servicestatustable tactical">
        <tr>
            <th>
                <?php echo _('Servicegroup'); ?>
            </th>
            <th>
                <?php echo _('Services'); ?>
            </th>
        </tr>
        <tr>
            <td>
                <?php echo $servicegroup; ?>
            </td>
            <td>
                <?php echo $service_output; ?>
            </td>
        </tr>
    </table>
    <?php
}
