<?php

register_tactical_overview_dashlet();

function register_tactical_overview_dashlet() {


	$dashlet_opts = array(
		DASHLET_NAME 		=> 'tactical_overview',
        DASHLET_TYPE        => DASHLET_TYPE_CORE,
		DASHLET_SERVER_TYPE => SERVER_TYPE_XI | SERVER_TYPE_CORE,
		DASHLET_VERSION		=> '1.0.0',
		DASHLET_DATE		=> '01/18/2017',
		DASHLET_AUTHOR		=> 'Nagios Enterprises',
		DASHLET_DESCRIPTION	=> 'Tactical Overview',
		DASHLET_COPYRIGHT	=> '&copy; 2017 Nagios Enterprises, LLC',
		DASHLET_HOMEPAGE	=> 'www.nagios.com',
		DASHLET_LICENSE     => _('Nagios Software License'),
		DASHLET_PREVIEW		=> get_dashlets_base_url() . 'tactical_overview/tactical_overview.png',
		DASHLET_LOAD_URL	=> get_dashlets_base_url() . 'tactical_overview/tactical_overview.php',
		DASHLET_TITLE		=> _('Tactical Overview'),
    	DASHLET_PARAMS		=> 'tactical_overview_dashlet_params',
		DASHLET_WIDTH       => 600,
    	);

	register_dashlet($dashlet_opts);
}

function tactical_overview_dashlet_params() {
    
    $servers = array('all' => _('All Servers'));
    foreach (get_servers() as $server) {
        $servers[$server['server_id']] = $server['name'];
    }

    return array(
        'server' => array(
            'name'      => _('Server'),
            'options'   => $servers, // in the format of array(val => humanreadable)
            ), 
        );
}