<?php
require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

dashlets_data_check();

tactical_overview_dashlet();

function tactical_overview_dashlet() {

	$server = grab_request_var('server');

	$data = array(
        'hosts_pending'         			=> 0,
        'hosts_up'              			=> 0,
        'hosts_down'            			=> 0,
        'hosts_unreachable'     			=> 0,
        'hosts_problems'					=> 0,
        'hosts_problems_unhandled'			=> 0,
        'hosts_count'						=> 0,

        'services_pending'         			=> 0,
        'services_ok'              			=> 0,
        'services_warning'        			=> 0,
        'services_critical'        			=> 0,
        'services_unknown'         			=> 0,
        'services_problems'					=> 0,
        'services_problems_unhandled'		=> 0,
        'services_count'					=> 0,

		// Modified to provide an accurate and formatted 'Last Updated' time
		// -acoil 2023-17-01
        'polled_time'						=> date("Y-m-d H:i:s", time()),
        );

	// grab an individual servers overview data
	if ($server != 'all') {

		// only grab the data we need for this server
		$server_data = get_server_data($server);

		if ($server_data !== false && is_array($server_data))
			$data = array_merge($data, $server_data);


	} else {
		// aggregate all server data
		$servers = get_servers();
		foreach ($servers as $server) {

			$server_data = get_server_data($server);

			if ($server_data) {
				foreach ($server_data as $key => $value) {
					if (isset($data[$key]) && $key != 'polled_time') {
							// Needed to add type handling as integers need to be added, but strings cannot
                        	// -acoil 2023-17-01
							if(gettype($data[$key]) == 'integer'){
								$data[$key] += $value;
							}
					} else {
						if ($key != 'polled_time') {
							$data[$key] = $value;
						}
					}
				}			
			}
		}

		$server = 'all';
	}
	
	// Sanitize data - polled_extras lets us overwrite $data keys with strings
	foreach ($data as $key => $value) {
		if($key != 'polled_time'){
			$data[$key] = intval($value);
		}
	}

	$havehostup						= empty($data['hosts_up']) ? 					'' : 'havehostup';
	$havehostdown					= empty($data['hosts_down']) ? 					'' : 'havehostdown';
	$havehostunreachable			= empty($data['hosts_unreachable']) ? 			'' : 'havehostunreachable';
	$havehostpending				= empty($data['hosts_pending']) ? 				'' : 'havehostpending';
	$haveunhandledhostproblems		= empty($data['hosts_problems_unhandled']) ? 	'' : 'haveunhandledhostproblems';
	$havehostproblems 				= empty($data['hosts_problems']) ? 				'' : 'havehostproblems';

	$haveserviceok 					= empty($data['services_ok']) ? 				'' : 'haveserviceok';
	$haveservicewarning				= empty($data['services_warning']) ? 			'' : 'haveservicewarning';
	$haveservicecritical			= empty($data['services_critical']) ? 			'' : 'haveservicecritical';
	$haveserviceunknown				= empty($data['services_unknown']) ? 			'' : 'haveserviceunknown';
	$haveservicepending				= empty($data['services_pending']) ? 			'' : 'haveservicepending';
	$haveunhandledserviceproblems 	= empty($data['services_problems_unhandled']) ? '' : 'haveunhandledserviceproblems';
	$haveserviceproblems 			= empty($data['services_problems']) ? 			'' : 'haveserviceproblems';

	if ($server != 'all' && function_exists('get_tactical_link')) {

		$server = get_server($server);
		if (is_array($server)) {

			$data['hosts_up'] = get_tactical_link($data['hosts_up'], $server, 
				"includes/components/xicore/status.php?&show=hosts&hoststatustypes=2&servicestatustypes=0", 
				"status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=2");

			$data['hosts_down'] = get_tactical_link($data['hosts_down'], $server, 
				"includes/components/xicore/status.php?&show=hosts&hoststatustypes=4&servicestatustypes=0", 
				"status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=4");

			$data['hosts_unreachable'] = get_tactical_link($data['hosts_unreachable'], $server, 
				"includes/components/xicore/status.php?&show=hosts&hoststatustypes=8&servicestatustypes=0", 
				"status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=8");

			$data['hosts_pending'] = get_tactical_link($data['hosts_pending'], $server, 
				"includes/components/xicore/status.php?&show=hosts&hoststatustypes=1&servicestatustypes=0", 
				"status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=1");

			$data['hosts_problems_unhandled'] = get_tactical_link($data['hosts_problems_unhandled'], $server, 
				"includes/components/xicore/status.php?&show=hosts&servicestatustypes=0&hoststatustypes=12&hostattr=10",
				"status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=12&hostprops=42");

			$data['hosts_problems'] = get_tactical_link($data['hosts_problems'], $server, 
				"includes/components/xicore/status.php?&show=hosts&hoststatustypes=12&servicestatustypes=0",
				"status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=12");

			$data['hosts_count'] = get_tactical_link($data['hosts_count'], $server, 
				"includes/components/xicore/status.php?&show=hosts&servicestatustypes=0",
				"status.cgi?hostgroup=all&style=hostdetail");

			$data['services_ok'] = get_tactical_link($data['services_ok'], $server, 
				"includes/components/xicore/status.php?&show=services&hoststatustypes=15&servicestatustypes=2", 
				"status.cgi?host=all&style=detail&servicestatustypes=2");

			$data['services_warning'] = get_tactical_link($data['services_warning'], $server, 
				"includes/components/xicore/status.php?&show=services&hoststatustypes=15&servicestatustypes=4", 
				"status.cgi?host=all&style=detail&servicestatustypes=4");

			$data['services_critical'] = get_tactical_link($data['services_critical'], $server, 
				"includes/components/xicore/status.php?&show=services&hoststatustypes=15&servicestatustypes=16", 
				"status.cgi?host=all&style=detail&servicestatustypes=16");

			$data['services_unknown'] = get_tactical_link($data['services_unknown'], $server, 
				"includes/components/xicore/status.php?&show=services&hoststatustypes=15&servicestatustypes=8", 
				"status.cgi?host=all&style=detail&servicestatustypes=8");

			$data['services_pending'] = get_tactical_link($data['services_pending'], $server, 
				"includes/components/xicore/status.php?&show=services&hoststatustypes=15&servicestatustypes=1", 
				"status.cgi?host=all&style=detail&servicestatustypes=1");

			$data['services_problems_unhandled'] = get_tactical_link($data['services_problems_unhandled'], $server, 
				"includes/components/xicore/status.php?&show=services&hoststatustypes=15&servicestatustypes=28&serviceattr=10",
				"status.cgi?host=all&type=detail&hoststatustypes=3&serviceprops=10&servicestatustypes=28");

			$data['services_problems'] = get_tactical_link($data['services_problems'], $server, 
				"includes/components/xicore/status.php?&show=services&hoststatustypes=15&servicestatustypes=28",
				"status.cgi?host=all&servicestatustypes=28");

			$data['services_count'] = get_tactical_link($data['services_count'], $server, 
				"includes/components/xicore/status.php?&show=services&hoststatustypes=15",
				"status.cgi?host=all");
		}
	}
	?>

	<table class="table table-condensed table-no-margin table-no-padding table-no-border tactical">
		<tr>
			<td class="host_status_summary_dashlet" style="padding-right: 10px;">
				<div class="infotable_title"><?php echo _("Host Status Overview"); ?></div>
				<table class="infotable table table-condensed table-striped table-bordered">
					<thead>
						<tr>
							<th>Up</th>
							<th>Down</th>
							<th>Unreachable</th>
							<th>Pending</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td>
								<div class="hostup <?php echo $havehostup; ?>">
									<?php echo $data['hosts_up']; ?>
								</div>
							</td>
							<td>
								<div class="hostdown <?php echo $havehostdown; ?>">
				    				<?php echo $data['hosts_down']; ?>
								</div>
							</td>
							<td>
								<div class="hostunreachable <?php echo $havehostunreachable; ?>">
									<?php echo $data['hosts_unreachable']; ?>
								</div>
							</td>
							<td>
								<div class="hostpending <?php echo $havehostpending; ?>">
									<?php echo $data['hosts_pending']; ?>
								</div>
							</td>
						</tr>
					</tbody>
					<thead>
						<tr>
							<th colspan="2">Unhandled</th>
							<th>Problems</th>
							<th>All</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td colspan="2">
								<div class="unhandledhostproblems <?php echo $haveunhandledhostproblems; ?>">
									<?php echo $data['hosts_problems_unhandled']; ?>
								</div>
							</td>
							<td>
								<div class="hostproblems <?php echo $havehostproblems; ?>">
									<?php echo $data['hosts_problems']; ?>
								</div>
							</td>
							<td>
								<div class="allhosts">
									<?php echo $data['hosts_count']; ?>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</td>
			<td class="service_status_summary_dashlet">
				<div class="infotable_title"><?php echo _("Service Status Overview"); ?></div>
				<table class="infotable table table-condensed table-striped table-bordered">
					<thead>
						<tr>
							<th>Ok</th>
							<th>Warning</th>
							<th>Unknown</th>
							<th>Critical</th>
							<th>Pending</th>
							</tr>
					</thead>
					<tbody>
						<tr>
							<td>
								<div class="serviceok <?php echo $haveserviceok; ?>">
									<?php echo $data['services_ok']; ?>
								</div>
							</td>
							<td>
								<div class="servicewarning <?php echo $haveservicewarning; ?>">
									<?php echo $data['services_warning']; ?>
								</div>
							</td>
							<td>
								<div class="serviceunknown <?php echo $haveserviceunknown; ?>">
									<?php echo $data['services_unknown']; ?>
								</div>
							</td>
							<td>
								<div class="servicecritical <?php echo $haveservicecritical; ?>">
									<?php echo $data['services_critical']; ?>
								</div>
							</td>
							<td>
								<div class="servicepending <?php echo $haveservicepending; ?>">
									<?php echo $data['services_pending']; ?>
								</div>
							</td>
						</tr>
					</tbody>
					<thead>
						<tr>
							<th colspan="2">Unhandled</th>
							<th colspan="2">Problems</th>
							<th>All</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td colspan="2">
								<div class="unhandledserviceproblems <?php echo $haveunhandledserviceproblems; ?>">
									<?php echo $data['services_problems_unhandled']; ?>
								</div>
							</td>
							<td colspan="2">
								<div class="serviceproblems <?php echo $haveserviceproblems; ?>">
									<?php echo $data['services_problems']; ?>
								</div>
							</td>
							<td>
								<div class="allservices">
									<?php echo $data['services_count']; ?>
								</div>
							</td>
						</tr>
					</tbody>
				</table>
			</td>
		</tr>
	</table>
	<div class="ajax_date"><?php echo _("Last Updated"); ?>: <?php echo convert_timestring_to_local_users_time($data['polled_time']); ?></div>
<?php
} // tactical_overview_dashlet()
