<?php
require_once(dirname(__FILE__) . '/../dashlet-helper.inc.php');

dashlets_data_check();

tactical_summary_dashlet();

function tactical_summary_dashlet() {

	$data = array(
        'hosts_pending'                     => 0,
        'hosts_up'                          => 0,
        'hosts_down'                        => 0,
        'hosts_unreachable'                 => 0,
        'hosts_problems'                    => 0,
        'hosts_problems_unhandled'          => 0,
        'hosts_flapping'                    => 0,
        'hosts_count'                       => 0,

        'services_pending'                  => 0,
        'services_ok'                       => 0,
        'services_warning'                  => 0,
        'services_critical'                 => 0,
        'services_unknown'                  => 0,
        'services_problems'                 => 0,
        'services_problems_unhandled'       => 0,
        'services_flapping'                 => 0,
        'services_count'                    => 0,
        );

    $totals = $data;

	?>
	<script type="text/javascript">
    $(function() {
        $('table').tablesorter({ 
            headers: { 0: { sorter: false}, 1: {sorter: false}, 2: {sorter: false} }
        });
    });
	</script>
	<table class="table tactical table-condensed table-no-margin table-striped table-bordered host_status_summary_dashlet borderless service_status_summary_dashlet borderless infotable">
        <thead>
            <tr>
                <th>&nbsp;</th>
                <th colspan="8"><?php echo _('Hosts'); ?></th>
                <th colspan="9"><?php echo _('Services'); ?></th>
            </tr>
			<tr>
				<th class="summary_sort"><?php echo _('Server'); ?></th>	
				<th class="summary_sort"><?php echo _('Up'); ?></th>
				<th class="summary_sort"><?php echo _('Down'); ?></th>
				<th class="summary_sort"><?php echo _('Unreachable'); ?></th>
				<th class="summary_sort"><?php echo _('Pending'); ?></th>
				<th class="summary_sort"><?php echo _('Flapping'); ?></th>
				<th class="summary_sort"><?php echo _('Problems'); ?></th>
				<th class="summary_sort"><?php echo _('Unhandled'); ?></th>
				<th class="summary_sort"><?php echo _('All'); ?></th>
				<th class="summary_sort"><?php echo _('Ok'); ?></th>
				<th class="summary_sort"><?php echo _('Warning'); ?></th>
				<th class="summary_sort"><?php echo _('Critical'); ?></th>
				<th class="summary_sort"><?php echo _('Unknown'); ?></th>
				<th class="summary_sort"><?php echo _('Pending'); ?></th>
				<th class="summary_sort"><?php echo _('Flapping'); ?></th>
				<th class="summary_sort"><?php echo _('Problems'); ?></th>
				<th class="summary_sort"><?php echo _('Unhandled'); ?></th>
				<th class="summary_sort"><?php echo _('All'); ?></th>
			</tr>
        </thead>
        <tbody>
	<?php
	$servers = get_servers();
	foreach ($servers as $server) {

        if ($server['server_type'] == SERVER_TYPE_NLS || $server['server_type'] == SERVER_TYPE_NNA) {
            continue;
        }

		$server_data = get_server_data($server);

        if (!$server_data || !is_array($server_data))
            $server_data = $data;

        $server_data = array_merge($data, $server_data);

		foreach ($server_data as $key => $value) {
            // Make sure these are integers - could have been overriden by polled_extras.
            $value = intval($value);
            $server_data[$key] = $value;

			if (isset($totals[$key]) && $key != 'polled_time') {
				$totals[$key] += $value;
			} else {
				$totals[$key] = $value;
			}
		}

		echo tactical_summary_build_row($server, $server_data);
	}

    echo '</tbody>';
    echo '<tfoot>';
	echo tactical_summary_build_row(_('Totals'), $totals, true);
    echo '</tfoot>';
	echo '</table>';

}

function tactical_summary_build_row($server, $data, $th_server = false) {

    $hosts_up_link = isset($data['hosts_up']) ? $data['hosts_up'] : '0';
    $hosts_down_link = isset($data['hosts_down']) ? $data['hosts_down'] : '0';
    $hosts_unreachable_link = isset($data['hosts_unreachable']) ? $data['hosts_unreachable'] : '0';
    $hosts_pending_link = isset($data['hosts_pending']) ? $data['hosts_pending'] : '0';
    $hosts_flapping_link = isset($data['hosts_flapping']) ? $data['hosts_flapping'] : '0';
    $hosts_problems_unhandled_link = isset($data['hosts_problems_unhandled']) ? $data['hosts_problems_unhandled'] : '0';
    $hosts_problems_link = isset($data['hosts_problems']) ? $data['hosts_problems'] : '0';
    $hosts_count_link = isset($data['hosts_count']) ? $data['hosts_count'] : '0';
    $services_ok_link = isset($data['services_ok']) ? $data['services_ok'] : '0';
    $services_warning_link = isset($data['services_warning']) ? $data['services_warning'] : '0';
    $services_critical_link = isset($data['services_critical']) ? $data['services_critical'] : '0';
    $services_unknown_link = isset($data['services_unknown']) ? $data['services_unknown'] : '0';
    $services_pending_link = isset($data['services_pending']) ? $data['services_pending'] : '0';
    $services_flapping_link = isset($data['services_flapping']) ? $data['services_flapping'] : '0';
    $services_problems_unhandled_link = isset($data['services_problems_unhandled']) ? $data['services_problems_unhandled'] : '0';
    $services_problems_link = isset($data['services_problems']) ? $data['services_problems'] : '0';
    $services_count_link = isset($data['services_count']) ? $data['services_count'] : '0';

	// $server means different things if we were passed string/array
	$server_name = $server;
	if (is_array($server)) {
		$server_name = $server['name'];

		if (function_exists('get_tactical_link')) {

            $hosts_up_link = get_tactical_link($data['hosts_up'], $server, 
                "includes/components/xicore/status.php?&show=hosts&hoststatustypes=2&servicestatustypes=0", 
                "status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=2");

            $hosts_down_link = get_tactical_link($data['hosts_down'], $server, 
                "includes/components/xicore/status.php?&show=hosts&hoststatustypes=4&servicestatustypes=0", 
                "status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=4");

            $hosts_unreachable_link = get_tactical_link($data['hosts_unreachable'], $server, 
                "includes/components/xicore/status.php?&show=hosts&hoststatustypes=8&servicestatustypes=0", 
                "status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=8");

            $hosts_pending_link = get_tactical_link($data['hosts_pending'], $server, 
                "includes/components/xicore/status.php?&show=hosts&hoststatustypes=1&servicestatustypes=0", 
                "status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=1");

            $hosts_flapping_link = get_tactical_link($data['hosts_flapping'], $server,
                "includes/components/xicore/status.php?show=hosts&hostattr=1024");

            $hosts_problems_unhandled_link = get_tactical_link($data['hosts_problems_unhandled'], $server, 
                "includes/components/xicore/status.php?&show=hosts&servicestatustypes=0&hoststatustypes=12&hostattr=10",
                "status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=12&hostprops=42");

            $hosts_problems_link = get_tactical_link($data['hosts_problems'], $server, 
                "includes/components/xicore/status.php?&show=hosts&hoststatustypes=12&servicestatustypes=0",
                "status.cgi?hostgroup=all&style=hostdetail&hoststatustypes=12");

            $hosts_count_link = get_tactical_link($data['hosts_count'], $server, 
                "includes/components/xicore/status.php?&show=hosts&servicestatustypes=0",
                "status.cgi?hostgroup=all&style=hostdetail");

            $services_ok_link = get_tactical_link($data['services_ok'], $server, 
                "includes/components/xicore/status.php?&show=services&hoststatustypes=15&servicestatustypes=2", 
                "status.cgi?host=all&style=detail&servicestatustypes=2");

            $services_warning_link = get_tactical_link($data['services_warning'], $server, 
                "includes/components/xicore/status.php?&show=services&hoststatustypes=15&servicestatustypes=4", 
                "status.cgi?host=all&style=detail&servicestatustypes=4");

            $services_critical_link = get_tactical_link($data['services_critical'], $server, 
                "includes/components/xicore/status.php?&show=services&hoststatustypes=15&servicestatustypes=16", 
                "status.cgi?host=all&style=detail&servicestatustypes=16");

            $services_unknown_link = get_tactical_link($data['services_unknown'], $server, 
                "includes/components/xicore/status.php?&show=services&hoststatustypes=15&servicestatustypes=8", 
                "status.cgi?host=all&style=detail&servicestatustypes=8");

            $services_pending_link = get_tactical_link($data['services_pending'], $server, 
                "includes/components/xicore/status.php?&show=services&hoststatustypes=15&servicestatustypes=1", 
                "status.cgi?host=all&style=detail&servicestatustypes=1");

            $services_flapping_link = get_tactical_link($data['services_flapping'], $server,
                "includes/components/xicore/status.php?show=services&serviceattr=1024");

            $services_problems_unhandled_link = get_tactical_link($data['services_problems_unhandled'], $server, 
                "includes/components/xicore/status.php?&show=services&hoststatustypes=15&servicestatustypes=28&serviceattr=10",
                "status.cgi?host=all&type=detail&hoststatustypes=3&serviceprops=10&servicestatustypes=28");

            $services_problems_link = get_tactical_link($data['services_problems'], $server, 
                "includes/components/xicore/status.php?&show=services&hoststatustypes=15&servicestatustypes=28",
                "status.cgi?host=all&servicestatustypes=28");

            $services_count_link = get_tactical_link($data['services_count'], $server, 
                "includes/components/xicore/status.php?&show=services&hoststatustypes=15",
                "status.cgi?host=all");
		}
    }

    $havehostup                     = empty($data['hosts_up']) ?                    '' : ' class="havehostup"';
    $havehostdown                   = empty($data['hosts_down']) ?                  '' : ' class="havehostdown"';
    $havehostunreachable            = empty($data['hosts_unreachable']) ?           ' class="hostunreachable"' : ' class="havehostunreachable"';
    $havehostpending                = empty($data['hosts_pending']) ?               ' class="hostpending"' : ' class="havehostpending"';
    $haveunhandledhostproblems      = empty($data['hosts_problems_unhandled']) ?    '' : ' class="haveunhandledhostproblems"';
    $havehostproblems               = empty($data['hosts_problems']) ?              '' : ' class="havehostproblems"';
    $havehostflapping               = empty($data['hosts_flapping']) ?              ' class="hostflapping"' : ' class="havehostflapping"';

    $haveserviceok                  = empty($data['services_ok']) ?                 '' : ' class="haveserviceok"';
    $haveservicewarning             = empty($data['services_warning']) ?            '' : ' class="haveservicewarning"';
    $haveservicecritical            = empty($data['services_critical']) ?           '' : ' class="haveservicecritical"';
    $haveserviceunknown             = empty($data['services_unknown']) ?            '' : ' class="haveserviceunknown"';
    $haveservicepending             = empty($data['services_pending']) ?            ' class="servicepending"' : ' class="haveservicepending"';
    $haveunhandledserviceproblems   = empty($data['services_problems_unhandled']) ? '' : ' class="haveunhandledserviceproblems"';
    $haveserviceproblems            = empty($data['services_problems']) ?           '' : ' class="haveserviceproblems"';
    $haveserviceflapping               = empty($data['services_flapping']) ?              ' class="serviceflapping"' : ' class="haveserviceflapping"';

    $row = '<tr>';

    if ($th_server)
	   $row .= "<th>{$server_name}</th>";
    else
       $row .= "<td style=\"text-align: left\">{$server_name}</td>";

	$row .= "<td" . $havehostup . ">{$hosts_up_link}</td>";
	$row .= "<td" . $havehostdown . ">{$hosts_down_link}</td>";
	$row .= "<td" . $havehostunreachable . ">{$hosts_unreachable_link}</td>";
	$row .= "<td" . $havehostpending . ">{$hosts_pending_link}</td>";
	$row .= "<td" . $havehostflapping . ">{$hosts_flapping_link}</td>";
	$row .= "<td" . $havehostproblems . ">{$hosts_problems_link}</td>";
	$row .= "<td" . $haveunhandledhostproblems . ">{$hosts_problems_unhandled_link}</td>";
	$row .= "<td class='hostcount'>{$hosts_count_link}</td>";

	$row .= "<td" . $haveserviceok . ">{$services_ok_link}</td>";
	$row .= "<td" . $haveservicewarning . ">{$services_warning_link}</td>";
	$row .= "<td" . $haveservicecritical . ">{$services_critical_link}</td>";
	$row .= "<td" . $haveserviceunknown . ">{$services_unknown_link}</td>";
	$row .= "<td" . $haveservicepending . ">{$services_pending_link}</td>";
	$row .= "<td" . $haveserviceflapping . ">{$services_flapping_link}</td>";
	$row .= "<td" . $haveserviceproblems . ">{$services_problems_link}</td>";
	$row .= "<td" . $haveunhandledserviceproblems . ">{$services_problems_unhandled_link}</td>";
	$row .= "<td class='servicecount'>{$services_count_link}</td>";

	$row .= '</tr>';

	return $row;
}
