<?php

// THIS IS A DASHLET EXAMPLE

register_test_dashlet();

function register_test_dashlet() {

    $servers = array();
    foreach (get_servers() as $server) {
        $servers[$server['server_id']] = $server['name'];
    }

    $poll_types = array(
        POLL_TYPE_HOSTSTATUS            => 'hoststatus',
        POLL_TYPE_SERVICESTATUS         => 'servicestatus',
        POLL_TYPE_ALERTS                => 'alerts',
        POLL_TYPE_NOTIFICATIONS         => 'notifications',
        //POLL_TYPE_STATEHISTORY          => 'statehistory',
        POLL_TYPE_COMMENT               => 'comment',
        POLL_TYPE_DOWNTIME              => 'downtime',
        POLL_TYPE_CONTACT               => 'contact',
        POLL_TYPE_HOST                  => 'host',
        POLL_TYPE_SERVICE               => 'service',
        POLL_TYPE_HOSTGROUP             => 'hostgroup',
        POLL_TYPE_SERVICEGROUP          => 'servicegroup',
        POLL_TYPE_CONTACTGROUP          => 'contactgroup',
        POLL_TYPE_HOSTGROUPMEMBERS      => 'hostgroupmembers',
        POLL_TYPE_SERVICEGROUPMEMBERS   => 'servicegroupmembers',
        POLL_TYPE_CONTACTGROUPMEMBERS   => 'contactgroupmembers',
        POLL_TYPE_STATUS                => 'status',
        POLL_TYPE_USER                  => 'user',
        );

	$dashlet_opts = array(

		// this is the identifier for the dashlet.
		// you could say this is pretty important
		DASHLET_NAME 		=> 'Test',

		// some meta information about the dashlet
		DASHLET_SERVER_TYPE => SERVER_TYPE_XI | SERVER_TYPE_CORE,
		DASHLET_VERSION		=> '1.0.0',
		DASHLET_DATE		=> '10/20/2016',
		DASHLET_AUTHOR		=> 'Nagios Enterprises',
		DASHLET_DESCRIPTION	=> 'Testing Dashlet',
		DASHLET_COPYRIGHT	=> '&copy; 2016 Nagios Enterprises, LLC',
		DASHLET_HOMEPAGE	=> 'www.nagios.com',
		DASHLET_LICENSE     => _('Nagios Software License'),

		// the image used to preview the dashlet
		DASHLET_PREVIEW		=> get_dashlets_base_url() . 'test/test.png',

		// the url that is loaded to display the dashlet
		DASHLET_LOAD_URL	=> get_dashlets_base_url() . 'test/test.php',

		// this is the variable set to =1 (?inline=1) in the query string
		// for the load_url whenever this dashlet is displayed inline of a page
		// e.g.: not on a dashboard
		// default is 'inline'
		DASHLET_INLINE_VAR	=> 'inline',

		// some defaults for viewing the dashlet once it's added to a dashboard
		DASHLET_TITLE		=> 'Testing Dashlet',
		DASHLET_BGCOLOR		=> 'ffffff',
		DASHLET_PADDING		=> '10',
		DASHLET_WIDTH		=> '300',
		DASHLET_HEIGHT		=> '200',
		DASHLET_REFRESH		=> '60', // seconds
		DASHLET_OPACITY		=> '1.00',

    	// the list of variables that are accepted by the load_url
    	// (these will be changeable in the dashlet well)
    	// you also need to set...
    	// 'name' (the human readable name of this var, to show up in the settings form)
    	// 'val' (if this param has a val at loadtime)
    	// 'options' (if this param has only specific values it can accept)
        // 'dependent' if your options are based on a dependent field!
        //             the array for options need to be based on the options 
        //             of the dependent field - see the example for dependent_opts below
    	DASHLET_PARAMS		=> array(

    		'server' => array(
    			'name'		=> 'Server',
    			'options'	=> $servers, // in the format of array(val => humanreadable)
    			), 

    		'poll_type' => array(
    			'name'		=> 'Poll Type',
    			'options'   => $poll_types,
    			),

            'dependent_opts' => array(
                'name'      => 'Dependent Field',
                'dependent' => 'opts',
                )

    		),

    	// these additional settings are ones that are configurable before the dashlet array is passed to get_dashlet, etc.
    	DATABASE_ID			=> 32423432, // the id that corresponds to this dashlet if so exists in dashboards_dashlets db table
    	DASHLET_PINNED 		=> false,
    	DASHLET_X 			=> '400', // meaningless if inline dashlet
    	DASHLET_Y 			=> '600', // meaningless if inline dashlet
    	DASHLET_ZINDEX		=> 1,
    	DASHLET_SHOW_TITLE	=> true, // false if inline dashlet no matter what is set here

	);

	register_dashlet($dashlet_opts);
}
